document.addEventListener('DOMContentLoaded', function () {
    var elements = document.querySelectorAll('[class*="animate-"]');
    var observer = new IntersectionObserver(function (entries, observer) {
        entries.forEach(function (entry) {
            if (entry.isIntersecting) {
                var container = entry.target.parentElement;
                var animateElements = Array.from(container.children).filter(function (element) {
                    return element.getAttribute('class') && element.getAttribute('class').includes('animate-');
                });

                animateElements.forEach(function (element, index) {
                    var animateClass = element.getAttribute('class').match(/animate-[\w-]+/)[0];
                    var newAnimateClass = animateClass.replace('animate-', 'animate__');

                    element.classList.remove(animateClass);
                    element.classList.add(newAnimateClass, 'animate__animated');
                    element.style.animationDelay = (index * 0.2) + 's';
                });

                animateElements.forEach(function (element) {
                    observer.unobserve(element);
                });
            }
        });
    }, {threshold: 0.5});

    elements.forEach(function (element) {
        observer.observe(element);
    });
});


document.addEventListener('DOMContentLoaded', function () {
    const section = document.querySelector('.cms-section-default');

    if (section) {
        const firstBlock = section.querySelector('.cms-block');
        const breadcrumb = document.querySelector('.breadcrumb');

        if (firstBlock && breadcrumb) {
            firstBlock.insertAdjacentElement('afterend', breadcrumb);
        }
    }
});