<?php declare(strict_types=1);

namespace WeinmanufakturTheme;

use Shopware\Core\Framework\Plugin;
use Shopware\Storefront\Framework\ThemeInterface;

class WeinmanufakturTheme extends Plugin implements ThemeInterface
{
    public function getThemeConfigPath(): string
    {
        return 'theme.json';
    }

    public function boot(): void
    {
        parent::boot();
    }

    public function getMigrationNamespace(): string
    {
        return $this->getNamespace() . '\Migration';
    }

    public function getViewPaths(): array
    {
        return [
            'Resources/views'
        ];
    }
}