import type { IconDefinition, IconPack } from '@fortawesome/fontawesome-common-types';
import type { Icon, IconParams } from '@fortawesome/fontawesome-svg-core'

export type IconPrefix = 'fass'|'fakd'|'fak';

export type IconName = 'bars'|'besteck'|'cart'|'chevron-down'|'daumen'|'download'|'fb'|'glass'|'insta'|'navicon'|'search'|'secure'|'temp'|'user'|'vegan4'|'wine-producer'|'wishlist';

export interface IconPackByPrefix {
  [key: string]: IconPack;
}

export interface IconLookup {
  prefix: IconPrefix;
  iconName: IconName;
}

declare module '@fortawesome/fontawesome-svg-core' {
  export function icon(icon: IconName | IconLookup, params?: IconParams): Icon;
  export function findIconDefinition(iconLookup: IconLookup): IconDefinition;
}

