<?php

return array(
	'label' => array(
		'Zentrierter Inhaltsbereich Anfang',
		'Erzeugt einen zentrierten Inhaltsbereich',
	),
	'types' => array('content', 'module'),
	'standardFields' => array('cssID', 'space'),
	'wrapper' => array(
		'type' => 'start',
	),
	'fields' => array(
		'backgroundImage' => array(
			'label' => array('Hintergrundbild oder -Video', 'Wählen Sie ein Bild oder mehrere Videodateien aus.'),
			'inputType' => 'fileTree',
			'eval' => array(
				'tl_class' => 'clr',
				'multiple' => true,
				'fieldType' => 'checkbox',
				'filesOnly' => true,
				'extensions' => \Config::get('validImageTypes') . ',mp4,webm,ogv,ogg',
        'orderField'=>'orderSRC',
        'isGallery' => false,
			),
		),
		'backgroundImageSize' => array(
			'label' => array('Bildbreite und Bildhöhe', ''),
			'inputType' => 'imageSize',
			'options' => \System::getImageSizes(),
			'reference' => &$GLOBALS['TL_LANG']['MSC'],
			'eval' => array(
				'rgxp' => 'digit',
				'tl_class' => 'w50',
				'includeBlankOption' => true,
			),
		),
		'backgroundSize' => array(
			'label' => array('Hintergrundbildgröße', ''),
			'inputType' => 'select',
			'options' => array(
				'' => 'Beschnitten',
				'contain' => 'Proportional',
				'100% 100%' => 'Verzerrt',
				'auto auto' => 'Originalgröße',
			),
			'eval' => array('tl_class' => 'w50'),
		),
		'backgroundPosition' => array(
			'label' => array('Hintergrundposition', 'Nicht mit Parallax-Effekt kombinierbar'),
			'inputType' => 'select',
			'options' => array(
				'' => '-',
				'0 0' => 'Links | Oben',
				'50% 0' => 'Mitte | Oben',
				'100% 0' => 'Rechts | Oben',
				'0 50%' => 'Links | Mitte',
				'50% 50%' => 'Mitte | Mitte',
				'100% 50%' => 'Rechts | Mitte',
				'0 100%' => 'Links | Unten',
				'50% 100%' => 'Mitte | Unten',
				'100% 100%' => 'Rechts | Unten',
			),
			'eval' => array('tl_class' => 'w50'),
		),
    'backgroundOpacity' => array(
      'label' => array('Hintergrundbildtransparenz', ''),
      'inputType'               => 'select',
      'options'                 => array
      (
        '10' => '10%',
        '20' => '20%',
        '30' => '30%',
        '40' => '40%',
        '50' => '50%',
        '60' => '60%',
        '70' => '70%',
        '80' => '80%',
        '90' => '90%',
        '100' => '100%',
      ),
      'eval'                    => array('tl_class' => 'w50','includeBlankOption'=>true),
    ),
    'backgroundVariation' => array(
      'label' => array('Hintergrundeffekt', ''),
      'inputType' => 'select',
      'options' => array(
        '' => '-',
        '-background-parallax' => 'Parallax',
        '-background-mousemove' => 'Mit der Maus bewegend',
        '-background-mousemove-inverted' => 'Entgegen der Maus bewegend',
      ),
      'eval' => array('tl_class' => 'w50'),
    ),
		'colorVariation' => array(
			'label' => array('Vordefinierte Hintergrundfarbe', 'Eine der vordefinierten Farben als Hintergrund verwenden. Die Farben lassen sich mit dem Theme Assistant, CSS oder Sass anpassen.'),
			'inputType' => 'select',
			'options' => array(
				'' => '-',
				'-alt-color' => 'Rot',
				'-alt-color2' => 'Schwarz',
				'-alt-color3' => 'Hellgrau',
			),
			'eval' => array('tl_class' => 'w50'),
		),
		'height' => array(
			'label' => array('Mindesthöhe erzwingen', 'Setzt die Mindesthöhe des Bereiches auf einen der im CSS definierten Werte.'),
			'inputType' => 'select',
			'options' => array(
				'' => '-',
				'-small' => 'Schmal',
				'-medium' => 'Mittel',
				'-large' => 'Hoch',
        '-full-vh' => 'Komplette Viewport-Höhe',
        /*'-full-vh-header' => 'Viewport-Höhe abzüglich Header',
        '-bgimage' => 'an Hintergrundbild ausrichten'*/
			),
			'eval' => array('tl_class' => 'w50'),
		),
        'valign' => array(
            'label' => array('Vertikale Ausrichtung', 'Legt die vertikale Ausrichtung des Inhalts fest.'),
            'inputType' => 'select',
            'options' => array(
                '' => '-',
                '-va-top' => 'Oben',
                '-va-middle' => 'Mitte',
                '-va-bottom' => 'Unten',
            ),
            'dependsOn' => array(
                'field' => 'height',
                'value' => '-full-vh'
            ),
            'eval' => array('tl_class' => 'w50'),
        ),
    'padding' => array(
      'label' => array('Innenabstand', 'Es wird Oben und Unten ein Innenabstand angewendet.'),
      'inputType' => 'select',
      'options' => array(
        '' => '-',
        '-padding' => 'Default',
        '-medium-padding' => 'Medium',
        '-large-padding' => 'Large',
        '-padding-top' => 'Small Top',
        '-medium-padding-top' => 'Medium Top',
        '-large-padding-top' => 'Large Top',
        '-padding-bottom' => 'Small Bottom',
        '-medium-padding-bottom' => 'Medium Bottom',
        '-large-padding-bottom' => 'Large Bottom',
      ),
      'eval' => array(
        'tl_class' => 'clr w50',
      ),
    ),
    'widthRestrict' => array(
        'label' => array('Begrenzte Hintergrundbreite', 'Der Hintergrund wird auf die max. Inhaltsbreite begrenzt anstatt über die volle Fensterbreite zu laufen.'),
        'inputType' => 'checkbox',
        'eval' => array(
            'tl_class' => 'w50 m12',
        ),
    ),
    'width' => array(
      'label' => array('Keine Breitenbegrenzung', 'Der Inhaltsbereich läuft über die gesamte verfügbare Breite seines Vaterelements.'),
      'inputType' => 'checkbox',
      'eval' => array(
        'tl_class' => 'w50 m12',
      ),
    ),
    /*'valignCenter' => array(
      'label' => array('Mind. Viewport Höhe', 'Der Inhaltsbereich hat mindestens die Höhe des Viewports. Der Inhalt wird zentriert dargestellt.'),
      'inputType' => 'checkbox',
      'eval' => array(
        'tl_class' => 'w50 m12',
      ),
    ),*/
    'invert' => array(
      'label' => array('Textfarbe invertiert', 'Invertierte Textfarbe, für bessere Lesbarkeit auf manchen Hintergünden.'),
      'inputType' => 'checkbox',
      'eval' => array(
        'tl_class' => 'w50 m12',
      ),
    ),
    'textShadow' => array(
      'label' => array('Text-Schatten', 'Kleiner Textschatten für bessere Lesbarkeit.'),
      'inputType' => 'checkbox',
      'eval' => array(
        'tl_class' => 'w50 m12',
      ),
    ),
    'shadow' => array(
      'label' => array('Schatten', 'Der Inhaltsbereich hat einen Schattenwurf nach außen.'),
      'inputType' => 'checkbox',
      'eval' => array(
        'tl_class' => 'w50 m12',
      ),
    ),
    'overlay' => array(
      'label' => array('Overlay hinzufügen', 'Über den Hintergrund wird ein zusätzliches Overlay-Element gelegt'),
      'inputType' => 'checkbox',
      'eval' => array(
        'tl_class' => 'w50 m12',
      ),
    ),
    'spacing' => array(
      'label' => array('Abstand'),
      'inputType' => 'group',
    ),
    'es_spacing' => array (
      'inputType' => 'standardField'
    ),
    'es_padding' => array (
      'inputType' => 'standardField'
    ),
    'es_textAlign' => array (
      'inputType' => 'standardField'
    ),
    'animate' => array(
      'label' => array('Animations-Einstellungen'),
      'inputType' => 'group',
    ),
    'es_animate' => array (
      'inputType' => 'standardField'
    ),
	),
);
