<?php

declare(strict_types=1);

namespace App\EventListener\DataContainer;

use App\Model\IsoProductMonthModel;
use Contao\CoreBundle\DependencyInjection\Attribute\AsCallback;
use Contao\DataContainer;
use Contao\Date;
use Isotope\Model\Product;

#[AsCallback(table: "tl_iso_product", target: "fields.attr_datum.load")]
class IsoProductAttrDatumLoadListener
{
    public function __invoke($varValue, DataContainer $dc): mixed
    {
        if ($dc->activeRecord->type == 2)
        {
            $GLOBALS['TL_DCA']['tl_iso_product']['fields']['attr_datum']['eval']['disabled'] = true;
            $GLOBALS['TL_DCA']['tl_iso_product']['fields']['attr_datum']['eval']['mandatory'] = false;
            $varValue = '';
        }
        return $varValue;
    }

}
