<?php
/**
 * TeamList for Contao
 *
 * Copyright (c) 2016 Benjamin Roth
 *
 * @license LGPL-3.0+
 */

/**
 * Table tl_esm_team_group
 */

use Contao\DC_Table;
use Contao\DataContainer;
use Contao\System;
use Contao\CoreBundle\Security\ContaoCorePermissions;

$GLOBALS['TL_DCA']['tl_iso_product_month'] = array
(

	// Config
	'config' => array
	(
		'dataContainer'               => DC_Table::class,
        'enableVersioning'            => false,
        'closed'                      => false,
        'notEditable'                 => false,
        'notDeletable'                => false,
		'sql' => array
		(
			'keys' => array
			(
				'id' => 'primary'
			)
		)
	),

	// List
	'list' => array
	(
		'sorting' => array
		(
			'mode'                    => DataContainer::MODE_SORTED,
			'fields'                  => array('month'),
			'flag'                    => 1,
			'panelLayout'             => 'filter,search;sort,limit',
		),
		'label' => array
		(
			'fields'                  => array('month'),
			'format'                  => '%s'
		),
		'global_operations' => array
		(
			'all' => array
			(
				'href'                => 'act=select',
				'class'               => 'header_edit_all',
				'attributes'          => 'onclick="Backend.getScrollOffset()" accesskey="e"'
			)
		),
		'operations' => array
		(
            'edit' => array
            (
                'href'                => 'act=edit',
                'icon'                => 'edit.svg'
            ),
            'copy' => array
			(
				'href'                => 'act=copy',
				'icon'                => 'copy.svg'
			),
            'delete' => array
            (
                'href'                => 'act=delete',
                'icon'                => 'delete.svg',
                'attributes'          => 'onclick="if(!confirm(\'' . ($GLOBALS['TL_LANG']['MSC']['deleteConfirm'] ?? null) . '\'))return false;Backend.getScrollOffset()"'
            ),
            'show' => array
            (
                'href'                => 'act=show',
                'icon'                => 'show.svg'
            )
		)
	),

	// Palettes
	'palettes' => array
	(
		'default'                     => '{title_legend},month'
	),

	// Subpalettes
	'subpalettes' => array
	(
	),

	// Fields
	'fields' => array
	(
		'id' => array
		(
			'sql'                     => "int(10) unsigned NOT NULL auto_increment",
            'relation'                 => ['type'=>'hasMany','load'=>'lazy','table'=>'tl_iso_product','field'=>'attr_monthYear']
		),
		'tstamp' => array
		(
			'sql'                     => "int(10) unsigned NOT NULL default '0'"
		),
		'month' => array
		(
			'exclude'                 => true,
			'inputType'               => 'text',
			'eval'                    => array('mandatory'=>true, 'tl_class'=>'w50'),
			'sql'                     => "varchar(64) NOT NULL default ''"
		)
	)
);
