<?php

declare(strict_types=1);

namespace App\EventListener\DataContainer;

use App\Model\IsoProductMonthModel;
use Contao\CoreBundle\DependencyInjection\Attribute\AsCallback;
use Contao\DataContainer;
use Contao\Date;
use Isotope\Model\Product;

#[AsCallback(table: "tl_iso_product", target: "config.onload")]
class IsoProductOnLoadListener
{
    public function __invoke(DataContainer $dc): void
    {
//        dump($GLOBALS['TL_DCA']['tl_iso_product']);
        if (($Months = IsoProductMonthModel::findAll()) === null)
        {
            return;
        }

        foreach ($Months as $month)
        {
            if (Product::countBy('attr_monthyear',$month->id) < 1)
            {
                $month->delete();
            }
        }
    }
}
