<?php
// rsce_boxes_config.php
return array(
    'label' => array('Zentrierter Featured-Block Anfang →', 'Erzeugt einen zentrierten Feature-Block (z.B. Weinlinie)'),
    'types' => array('content','module'),
    'contentCategory' => 'featured',
    'standardFields' => array('cssID', 'space'),
    'wrapper' => array(
        'type' => 'start',
    ),
    'fields' => array(
        'content_set' => array(
            'label' => array('Inhaltsspalte'),
            'inputType' => 'group',
        ),
        'contentPosition' => array(
            'label' => array('Position', 'Legt fest ob der Inhalt links oder rechts vom Bild positioniert ist.'),
            'inputType' => 'select',
            'options' => array(
                '' => 'Rechts',
                '-text-left' => 'Links',
            ),
            'eval' => array('tl_class' => 'w50'),
        ),
        'image_set' => array(
            'label' => array('Bildspalte'),
            'inputType' => 'group',
        ),
        'backgroundImage' => array(
            'label' => array('Bild oder Video', 'Wählen Sie ein Bild oder eine Videodatei aus.'),
            'inputType' => 'fileTree',
            'eval' => array(
                'tl_class' => 'clr',
                'multiple' => false,
                'fieldType' => 'radio',
                'filesOnly' => true,
                'extensions' => \Config::get('validImageTypes') . ',mp4,webm,ogv,ogg',
                'orderField'=>'orderSRC',
//        'isGallery' => true,
            ),
        ),
        'backgroundImageSize' => array(
            'label' => array('Bildbreite und Bildhöhe', ''),
            'inputType' => 'imageSize',
            'options' => \System::getContainer()->get('contao.image.image_sizes')->getOptionsForUser(BackendUser::getInstance()),
            'reference' => &$GLOBALS['TL_LANG']['MSC'],
            'eval' => array(
                'rgxp' => 'digit',
                'tl_class' => 'w50',
                'includeBlankOption' => true,
            ),
        ),
        'backgroundSize' => array(
            'label' => array('Bildanpassung', ''),
            'inputType' => 'select',
            'options' => array(
                'cover' => 'Beschnitten',
                'contain' => 'Proportional',
                '100% 100%' => 'Verzerrt',
                'auto auto' => 'Originalgröße',
            ),
            'eval' => array('tl_class' => 'w50'),
        ),
        'backgroundPosition' => array(
            'label' => array('Position', 'Bildausrichtung'),
            'inputType' => 'select',
            'options' => array(
                '' => '-',
                '0 0' => 'Links | Oben',
                '50% 0' => 'Mitte | Oben',
                '100% 0' => 'Rechts | Oben',
                '0 50%' => 'Links | Mitte',
                '50% 50%' => 'Mitte | Mitte',
                '100% 50%' => 'Rechts | Mitte',
                '0 100%' => 'Links | Unten',
                '50% 100%' => 'Mitte | Unten',
                '100% 100%' => 'Rechts | Unten',
            ),
            'eval' => array('tl_class' => 'w50'),
        ),
        'featureLink' => array(
            'label' => array('Featurelink unter Bild', 'Stellt einen prominenten Link unterhalb des Bildes dar.'),
            'inputType' => 'checkbox',
            'eval' => array(
                'tl_class' => 'w50 m12 clr',
            ),
        ),
        'linkLabel' => array(
            'label' => array('Link-Text', ''),
            'inputType' => 'text',
            'eval' => array('tl_class' => 'w50', 'mandatory'=>true),
            'dependsOn' => array(
                'field' => 'featureLink'
            )
        ),
        'linkUrl' => array(
            'label' => array('Link-URL', 'Beispiele: {{link_url::seitenalias}} (Alias, ID oder anderer Inserttag), http://example.com'),
            'inputType' => 'url',
            'eval' => array('tl_class' => 'w50', 'mandatory'=>true),
            'dependsOn' => array(
                'field' => 'featureLink'
            )
        ),
        'linkTitle' => array(
            'label' => array('Link-Titel', 'Wird beim hovern mit der Maus dargestellt.'),
            'inputType' => 'text',
            'eval' => array('tl_class' => 'w50'),
            'dependsOn' => array(
                'field' => 'featureLink'
            )
        ),
        'linkAlign' => array(
            'label' => array('Link-Ausrichtung', 'Horizontale Ausrichtung des Links.'),
            'inputType' => 'select',
            'options' => array(
                '' => 'Links',
                '-alignCenter' => 'Mitte',
                '-alignRight' => 'Rechts',
            ),
            'eval' => array('tl_class' => 'w50'),
        ),
        'newWindow' => array(
            'label' => $GLOBALS['TL_LANG']['MSC']['target'],
            'inputType' => 'checkbox',
            'eval' => array('tl_class' => 'w50 clr'),
            'dependsOn' => array(
                'field' => 'featureLink'
            )
        ),
        'layout_set' => array(
            'label' => array('Layoutoptionen'),
            'inputType' => 'group',
        ),
        'padding' => array(
            'label' => array('Innenabstand', 'Es wird Oben und Unten ein Innenabstand angewendet.'),
            'inputType' => 'select',
            'options' => array(
                '' => '-',
                '-padding' => 'Default',
                '-medium-padding' => 'Medium',
                '-large-padding' => 'Large',
                '-padding-top' => 'Small Top',
                '-medium-padding-top' => 'Medium Top',
                '-large-padding-top' => 'Large Top',
                '-padding-bottom' => 'Small Bottom',
                '-medium-padding-bottom' => 'Medium Bottom',
                '-large-padding-bottom' => 'Large Bottom',
            ),
            'eval' => array(
                'tl_class' => 'w50',
            ),
        ),
        'valign' => array(
            'label' => array('Vertikale Ausrichtung', 'Vertikale Ausrichtung (nur in Verbindung mit &quot;Mind. Viewport Höhe&quot;).'),
            'inputType' => 'select',
            'options' => array(
                '-valign-top' => 'Oben',
                '-valign-center' => 'Mitte',
                '-valign-bottom' => 'Unten',
            ),
            'eval' => array('tl_class' => 'w50'),
        ),
        'colorVariation' => array(
            'label' => array('Vordefinierte Hintergrundfarbe', 'Eine der vordefinierten Farben als Hintergrund verwenden. Die Farben lassen sich mit dem Theme Assistant, CSS oder Sass anpassen.'),
            'inputType' => 'select',
            'options' => array(
                '' => '-',
                '-alt-color' => 'Leichtes Platin',
                '-alt-color2' => 'Footer',
                '-alt-color3' => 'Footer-Alternativ',
            ),
            'eval' => array('tl_class' => 'w50'),
        ),
        'viewportHeight' => array(
            'label' => array('Mind. Viewport Höhe', 'Der Inhaltsbereich hat mindestens die Höhe des Viewports. Der Inhalt wird zentriert dargestellt.'),
            'inputType' => 'checkbox',
            'eval' => array(
                'tl_class' => 'w50 m12 clr',
            ),
        ),
        'spacing' => array(
            'label' => array('Abstand'),
            'inputType' => 'group',
        ),
        'es_spacing' => array (
            'inputType' => 'standardField'
        ),
        'es_padding' => array (
            'inputType' => 'standardField'
        ),
    ),
);
