<?php

declare(strict_types=1);

namespace App\EventListener\DataContainer;

use Contao\Controller;
use Contao\CoreBundle\DependencyInjection\Attribute\AsCallback;
use Contao\Image;

#[AsCallback(table: "tl_esm_team", target: "list.sorting.child_record")]
class TeamListSortingChildRecordListener
{
    public function __invoke(array $recordData): string
    {
        $imageService = Controller::getContainer()->get('contao.image.factory');
        $projectDir = Controller::getContainer()->getParameter('kernel.project_dir');
        $strImage = '';

        if (($image = \FilesModel::findByUuid($recordData['singleSRC'])) !== null)
        {
            $strImage = sprintf('<img src="%s">',$imageService->create($projectDir. '/' .$image->path,[50,50])->getUrl($projectDir));
        }


        return '<div style="float: left; width: 75px">'.$strImage.'</div>
<div style="float: left; width: 35%;">' . $recordData['firstname'] . ' ' . $recordData['lastname'] . '</div>
<div style="font-size: .625rem; color: #c6c6c6;"><strong>[' . $recordData['position'] . ']</strong></div>' . "\n";
        return '';
    }
}
