<?php
// rsce_boxes_config.php
return array(
  'label' => array('Hero-Bild', 'Hero-Bild mit Text'),
  'types' => array('content'),
  'contentCategory' => 'media',
  'standardFields' => array('cssID'),
  'fields' => array(
    'text_set' => array(
      'label' => array('Text'),
      'inputType' => 'group',
    ),
    'text' => array (
      'label' => array('Text'),
      'inputType'               => 'inputUnit',
      'default'                 => array('value'=>'', 'unit'=>'h1'),
      'options'                 => array('h1', 'h2', 'h3', 'h4', 'h5', 'h6'),
      'eval'                    => array('maxlength'=>200, 'tl_class'=>'w50 clr'),
    ),
    'background_set' => array(
      'label' => array('Hintergrundbild'),
      'inputType' => 'group',
    ),
    'backgroundImage' => array(
      'label' => array('Hintergrundbild oder -Video', 'Wählen Sie ein Bild oder mehrere Videodateien aus.'),
      'inputType' => 'fileTree',
      'eval' => array(
        'tl_class' => 'clr',
        'multiple' => true,
        'fieldType' => 'checkbox',
        'filesOnly' => true,
        'extensions' => \Config::get('validImageTypes') . ',mp4,webm,ogv,ogg',
        'orderField'=>'orderSRC',
        'isGallery' => true,
      ),
    ),
    'backgroundImageSize' => array(
      'label' => array('Bildbreite und Bildhöhe', ''),
      'inputType' => 'imageSize',
      'options' => \System::getContainer()->get('contao.image.image_sizes')->getOptionsForUser(BackendUser::getInstance()),
      'reference' => &$GLOBALS['TL_LANG']['MSC'],
      'eval' => array(
        'rgxp' => 'digit',
        'tl_class' => 'w50',
        'includeBlankOption' => true,
      ),
    ),
    'backgroundSize' => array(
      'label' => array('Hintergrundbildgröße', ''),
      'inputType' => 'select',
      'options' => array(
        '' => 'Beschnitten',
        'contain' => 'Proportional',
        '100% 100%' => 'Verzerrt',
        'auto auto' => 'Originalgröße',
      ),
      'eval' => array('tl_class' => 'w50'),
    ),
    'backgroundPosition' => array(
      'label' => array('Hintergrundposition', 'Nicht mit Parallax-Effekt kombinierbar'),
      'inputType' => 'select',
      'options' => array(
        '' => '-',
        '0 0' => 'Links | Oben',
        '50% 0' => 'Mitte | Oben',
        '100% 0' => 'Rechts | Oben',
        '0 50%' => 'Links | Mitte',
        '50% 50%' => 'Mitte | Mitte',
        '100% 50%' => 'Rechts | Mitte',
        '0 100%' => 'Links | Unten',
        '50% 100%' => 'Mitte | Unten',
        '100% 100%' => 'Rechts | Unten',
      ),
      'eval' => array('tl_class' => 'w50'),
    ),
    'colorVariation' => array(
      'label' => array('Vordefinierte Hintergrundfarbe', 'Eine der vordefinierten Farben als Hintergrund verwenden. Die Farben lassen sich mit dem Theme Assistant, CSS oder Sass anpassen.'),
      'inputType' => 'select',
      'options' => array(
        '' => '-',
        '-alt-color' => 'Alternative Hintergrundfarbe',
      ),
      'eval' => array('tl_class' => 'w50'),
    ),
      'height' => array(
          'label' => array('Mindesthöhe erzwingen', 'Setzt die Mindesthöhe des Bereiches auf einen der im CSS definierten Werte.'),
          'inputType' => 'select',
          'options' => array(
              '' => '-',
              '-small' => 'Schmal',
              '-medium' => 'Mittel',
              '-large' => 'Hoch',
              '-full-vh' => 'Komplette Viewport-Höhe',
              '-full-vh-header' => 'Viewport-Höhe abzüglich Header',
              '-bgimage' => 'an Hintergrundbild ausrichten'
          ),
          'eval' => array('tl_class' => 'w50'),
      ),
    'playerAspect' => array (
      'inputType' => 'standardField'
    ),
    'arrow_set' => array(
      'label' => array('Pfeil'),
      'inputType' => 'group',
    ),
    'showArrow' => array(
      'label' => array('Pfeil anzeigen', 'Blendet einen Pfeil nach unten ein.'),
      'inputType' => 'checkbox',
      'eval' => array(
        'tl_class' => 'w50',
      ),
    ),
    'arrowAlternate' => array(
      'label' => array('Pfeilfarbe invertieren', 'Invertiert die Pfeilfarbe.'),
      'inputType' => 'checkbox',
      'eval' => array(
        'tl_class' => 'w50',
      ),
    ),
  ),
);
