<?php
// rsce_boxes_config.php
return array(
    'label' => array('Zentrierter Inhaltsbereich mit halbseitigem Bild Start', 'Erzeugt einen zentrierten Inhaltsbereich'),
    'types' => array('content','module'),
    'standardFields' => array('cssID', 'space'),
    'wrapper' => array(
        'type' => 'start',
    ),
    'fields' => array(
        'text_set' => array(
            'label' => array('Textspalte'),
            'inputType' => 'group',
        ),
        'textPosition' => array(
            'label' => array('Textposition', 'Legt fest ob der Text links oder rechts vom Bild positioniert ist.'),
            'inputType' => 'select',
            'options' => array(
                '' => 'Links',
                '-text-right' => 'Rechts',
            ),
            'eval' => array('tl_class' => 'w50'),
        ),
        'image_set' => array(
            'label' => array('Bildspalte'),
            'inputType' => 'group',
        ),
        'backgroundImage' => array(
            'label' => array('Bild oder Video', 'Wählen Sie ein Bild oder mehrere Videodateien aus.'),
            'inputType' => 'fileTree',
            'eval' => array(
                'tl_class' => 'clr',
                'multiple' => true,
                'fieldType' => 'checkbox',
                'filesOnly' => true,
                'extensions' => \Config::get('validImageTypes') . ',mp4,webm,ogv,ogg',
                'orderField'=>'orderSRC',
//        'isGallery' => true,
            ),
        ),
        'backgroundImageSize' => array(
            'label' => array('Bildbreite und Bildhöhe', ''),
            'inputType' => 'imageSize',
            'options' => \System::getContainer()->get('contao.image.image_sizes')->getOptionsForUser(BackendUser::getInstance()),
            'reference' => &$GLOBALS['TL_LANG']['MSC'],
            'eval' => array(
                'rgxp' => 'digit',
                'tl_class' => 'w50',
                'includeBlankOption' => true,
            ),
        ),
        'backgroundSize' => array(
            'label' => array('Bildanpassung', ''),
            'inputType' => 'select',
            'options' => array(
                '' => 'Beschnitten',
                'contain' => 'Proportional',
                '100% 100%' => 'Verzerrt',
                'auto auto' => 'Originalgröße',
            ),
            'eval' => array('tl_class' => 'w50'),
        ),
        'backgroundPosition' => array(
            'label' => array('Position', 'Nicht mit Parallax-Effekt kombinierbar'),
            'inputType' => 'select',
            'options' => array(
                '' => '-',
                '0 0' => 'Links | Oben',
                '50% 0' => 'Mitte | Oben',
                '100% 0' => 'Rechts | Oben',
                '0 50%' => 'Links | Mitte',
                '50% 50%' => 'Mitte | Mitte',
                '100% 50%' => 'Rechts | Mitte',
                '0 100%' => 'Links | Unten',
                '50% 100%' => 'Mitte | Unten',
                '100% 100%' => 'Rechts | Unten',
            ),
            'eval' => array('tl_class' => 'w50'),
        ),
        'padding' => array(
            'label' => array('Innenabstand', 'Es wird Oben und Unten ein Innenabstand angewendet.'),
            'inputType' => 'select',
            'options' => array(
                '' => '-',
                '-padding' => 'Default',
                '-medium-padding' => 'Medium',
                '-large-padding' => 'Large',
                '-padding-top' => 'Small Top',
                '-medium-padding-top' => 'Medium Top',
                '-large-padding-top' => 'Large Top',
                '-padding-bottom' => 'Small Bottom',
                '-medium-padding-bottom' => 'Medium Bottom',
                '-large-padding-bottom' => 'Large Bottom',
            ),
            'eval' => array(
                'tl_class' => 'w50',
            ),
        ),
        'valignCenter' => array(
            'label' => array('Mind. Viewport Höhe', 'Der Inhaltsbereich hat mindestens die Höhe des Viewports. Der Inhalt wird zentriert dargestellt.'),
            'inputType' => 'checkbox',
            'eval' => array(
                'tl_class' => 'w50 m12 clr',
            ),
        ),
        'valign' => array(
            'label' => array('Vertikale Ausrichtung', 'Vertikale Ausrichtung (nur in Verbindung mit &quot;Mind. Viewport Höhe&quot;).'),
            'inputType' => 'select',
            'options' => array(
                '' => 'Mitte',
                '-valignTop' => 'Oben',
                '-valignBottom' => 'Unten',
            ),
            'eval' => array('tl_class' => 'w50'),
        ),
        'spacing' => array(
            'label' => array('Abstand'),
            'inputType' => 'group',
        ),
        'es_spacing' => array (
            'inputType' => 'standardField'
        ),
        'es_padding' => array (
            'inputType' => 'standardField'
        ),
    ),
);