<?php

/**
 * viabook platform for Contao Open Source CMS
 *
 * Copyright (C) 2012-2013 eSalesMedia
 *
 * @package    eSM_viabook
 * @link       http://www.esales-media.de
 * @license    commercial
 *
 * @author     Benjamin Roth <benjamin@esales-media.de>
 */

namespace eSM_isotope_custom\Module;

use Isotope\Isotope;

class CumulativeFilter extends \Isotope\Module\CumulativeFilter
{
  protected function compile()
  {
    parent::compile();
    $objCache = Isotope::getRequestCache();
    $this->Template->iso_rc_id = $objCache->id;
  }

  protected function generateOptionItem($attribute, $label, $value, $matchCount, $isActive, array $option = [])
  {
    $arrOption = parent::generateOptionItem($attribute, $label, $value, $matchCount, $isActive);
    $arrOption['value'] = base64_encode($this->id . ';' . ($isActive ? 'del' : 'add') . ';' . $attribute . ';' . $value);
    $arrOption['attribute'] = $GLOBALS['TL_DCA']['tl_iso_product']['fields'][$attribute]['label'][0];
    return $arrOption;
  }


}