<?php

/**
 * Custom extension for Isotope for Contao
 *
 * Copyright (c) 2014 Benjamin Roth [http://www.esales-media.de]
 *
 * @package eSM_isotope_custom
 * @link    http://www.esales-media.de
 * @license commercial
 */

$GLOBALS['TL_DCA']['tl_iso_product']['config']['onload_callback'][] = array('eSM_isotope_custom\tl_iso_product','injectIntoPalettes');
$GLOBALS['TL_DCA']['tl_iso_product']['config']['onsubmit_callback'][] = array('eSM_isotope_custom\tl_iso_product','generateSearchKeywords');

$GLOBALS['TL_DCA']['tl_iso_product']['list']['label']['label_callback'] = array('eSM_isotope_custom\tl_iso_product','generateLabel');
$GLOBALS['TL_DCA']['tl_iso_product']['list']['label']['fields'] = array('images', 'name', 'sku', 'price', 'jahrgang', 'qualitaet','geschmack','weinlinie');


$GLOBALS['TL_DCA']['tl_iso_product']['fields']['fallback']['save_callback'] = array
(
  array('eSM_isotope_custom\tl_iso_product','reset')
);
$GLOBALS['TL_DCA']['tl_iso_product']['fields']['search_keywords'] = array
(
  'label'                 => &$GLOBALS['TL_LANG']['tl_iso_product']['search_keywords'],
  'exclude'               => true,
  'inputType'             => 'text',
  'eval'                  => array('mandatory'=>false, 'tl_class'=>'w50','readonly'=>true),
  'attributes'            => array('legend'=>'meta_legend', 'fe_search'=>true, 'fixed'=>true, 'variant_fixed'=>true, 'systemColumn'=>true),
  'sql'                   => "varchar(1055) NOT NULL default ''"
);

$GLOBALS['TL_DCA']['tl_iso_product']['fields']['not_buyable'] = array
(
  'label'                 => &$GLOBALS['TL_LANG']['tl_iso_product']['not_buyable'],
  'exclude'               => true,
  'filter'                => true,
  'inputType'             => 'checkbox',
  'attributes'            => array('legend'=>'publish_legend', 'fixed'=>true, 'inherit'=>true, 'systemColumn'=>true),
  'eval'                  => array('tl_class'=>'w50 m12 clr','doNotCopy'=>true),
  'sql'                   => "char(1) NOT NULL default ''",
);

$GLOBALS['TL_DCA']['tl_iso_product']['fields']['not_buyable_text'] = array
(
  'label'                 => &$GLOBALS['TL_LANG']['tl_iso_product']['not_buyable_text'],
  'exclude'               => true,
  'inputType'             => 'text',
  'eval'                  => array('maxlength'=>255,'tl_class'=>'w50'),
  'attributes'            => array('legend'=>'publish_legend', 'fixed'=>true, 'inherit'=>true, 'systemColumn'=>true),
  'sql'                   => "varchar(255) NOT NULL default ''",
);

$GLOBALS['TL_DCA']['tl_iso_product']['fields']['product_of_month'] = array
(
  'label'                 => &$GLOBALS['TL_LANG']['tl_iso_product']['product_of_month'],
  'exclude'               => true,
  'filter'                => true,
  'inputType'             => 'checkbox',
  'eval'                  => array('unique'=>true,'tl_class'=>''),
  'attributes'            => array('legend'=>'options_legend', 'fixed'=>true, 'variant_fixed'=>true, 'systemColumn'=>true),
  'sql'                   => "char(1) NOT NULL default ''",
);