<?php

/**
 * viabook platform for Contao Open Source CMS
 *
 * Copyright (C) 2012-2014 eSalesMedia
 *
 * @package    eSM_viabook
 * @link       http://www.esales-media.de
 * @license    commercial
 *
 * @author     Benjamin Roth <benjamin@esales-media.de>
 */


/**
 * Namespace
 */
namespace eSM_isotope_custom\Pdf;

/**
 * Include required tcpdf config files
 */

require_once(TL_ROOT . '/system/modules/eSM_isotope_custom/config/af_tcpdf.php');
require_once(TL_ROOT . '/vendor/tecnickcom/tcpdf/tcpdf.php');

class AFPDF extends \TCPDF {

    public function Header()
    {
        // Header
        // get the current page break margin
        $bMargin = $this->getBreakMargin();
        // get current auto-page-break mode
        $auto_page_break = $this->getAutoPageBreak();
        // disable auto-page-break
        $this->SetAutoPageBreak(false, 0);
        // set bacground image
        // restore auto-page-break status
        $this->SetAutoPageBreak($auto_page_break, $bMargin);
        $this->SetMargins(0,0,0);
        $this->SetFooterMargin(0);
        $this->Image(TL_ROOT . '/files/base/layout/img/pdf/header_expertise.jpg', 0,30,210,0,'','','T',true,300);
        $this->Image(TL_ROOT . '/files/base/layout/img/pdf/logo.png', 75, 10,60,0,'PNG','','T',true,300);
        $this->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
        $this->SetFooterMargin(PDF_MARGIN_FOOTER);
    }


    // Page footer
    public function Footer()
    {
        // Footer
        // get the current page break margin
        $bMargin = $this->getBreakMargin();
        // get current auto-page-break mode
        $auto_page_break = $this->getAutoPageBreak();
        // disable auto-page-break
        $this->SetAutoPageBreak(false, 0);
        // set bacground image
        // restore auto-page-break status
        $this->SetAutoPageBreak($auto_page_break, $bMargin);
        $this->SetMargins(0,0,0);
        $this->SetFooterMargin(0);

//        $this->SetDrawColor(29,94,65);
//        $this->SetLineWidth(0.5);
//        $this->Line(15, 277, 195, 277, 'F');
        $this->Rect(0,277,210,20,"F",array(),array(29,94,65));


        $this->SetTextColor(255,255,255);
        $this->SetXY(15, 282);
        $this->CreateCell(180, 10, 'www.affentaler.de', 0, 10, '', 'R', PDF_FONT_NAME_DATA);
        $this->ImageSVG(TL_ROOT . '/files/base/layout/img/scroll-logo.svg', 100, 282,0,10);


//        $this->Image(TL_ROOT . '/files/themes/gengenbach_v1/assets/images/pdf/expertise_papier_footer.jpg', 0, 278,210,0,'JPG','','T',true,300);
        $this->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
        $this->SetFooterMargin(PDF_MARGIN_FOOTER);
    }

    public function CreateTextBox($textval, $x = 0, $y = 0, $width = 0, $height = 0, $fontsize = PDF_FONT_SIZE_MAIN, $fontstyle = '', $align = 'L', $font = PDF_FONT_NAME_MAIN)
    {
        $margins = $this->getMargins();
        $this->SetFont($font, $fontstyle, $fontsize);

        if (!strlen($y))
        {
            $this->SetX($x+$margins['left']);
        } else {
            $this->SetXY($x+$margins['left'], $y);
        }

        // Start clipping.
        $this->StartTransform();

        if (!strlen($y))
        {
            $x = $x+$margins['left'];
            $y = $y+$margins['top'];
            $this->SetXY($x, $y);
        } else {
            $x = $x+$margins['left'];
            $this->SetX($x);
        }

        if (!$height)
        {
            $pdf2 = clone $this;
            $pdf2->setPrintHeader(false);
            $pdf2->setPrintFooter(false);
            $pdf2->AddPage();
            $pdf2->Cell($width, $height, $textval, 0, false, $align);
            $height = $pdf2->GetY();
            unset($pdf2);
        }

        // Draw clipping rectangle to match cell.
        $this->Rect($x, $y, $width, $height, 'CNZ');

        $this->Cell($width, $height, $textval, 0, false, $align);

        // Stop clipping.
        $this->StopTransform();
    }

    public function lbr($fltNo=1)
    {
        $this->SetY($this->GetY()+(($this->getFontSize()*$this->getCellHeightRatio())*floatval($fltNo)));
    }

    public function CreateHTMLBox($htmlVal, $x = 0, $y = 0, $width = 0, $height = 0, $fontsize = PDF_FONT_SIZE_MAIN, $fontstyle = '', $align = 'L', $font = PDF_FONT_NAME_MAIN)
    {
        $margins = $this->getMargins();
        $this->SetFont($font, $fontstyle, $fontsize);

        // Start clipping.
        $this->StartTransform();

        if (!strlen($y))
        {
            $x = $x+$margins['left'];
            $y = $y+$margins['top'];
        } else {
            $x = $x+$margins['left'];
        }

        if (!$height)
        {
            $pdf2 = clone $this;
            $pdf2->setPrintHeader(false);
            $pdf2->setPrintFooter(false);
            $pdf2->AddPage();
            $pdf2->writeHTMLCell($width, $height, 0, 0, $htmlVal, 0, 1, false, true, $align);
            $height = $pdf2->GetY();
            unset($pdf2);
        }

        // Draw clipping rectangle to match html cell.
        $this->Rect($x, $y, $width, $height, 'CNZ');

        // Output html.
        $this->writeHTMLCell($width, $height, $x, $y, $htmlVal, 0, 0, false, true, $align);

        // Stop clipping.
        $this->StopTransform();
    }


    public function CreateCell($w, $h = 0, $txt = '', $ln = 0, $fontsize = PDF_FONT_SIZE_MAIN, $fontstyle = '', $align = 'L', $font = PDF_FONT_NAME_MAIN)
    {
        $margins = $this->getMargins();
        $currFontsize = $this->getFontSize();
        $currFontfamily = $this->getFontFamily();
        $currFontstyle = $this->getFontStyle();

        $x = $this->GetX();
        $y = $this->GetY();

        $this->SetFont($font, $fontstyle, $fontsize);

        // Start clipping.
        $this->StartTransform();

        if (!$h)
        {
            $h = ($this->getFontSize()*$this->getCellHeightRatio());
        }

        // Draw clipping rectangle to match html cell.
        $this->Rect($x, $y, $w, $h, 'CNZ');

        $this->Cell($w,$h,$txt,0,$ln,$align);
        $this->SetFont($currFontfamily, $currFontstyle, $currFontsize);

        // Stop clipping.
        $this->StopTransform();

        if (!$ln)
        {
            $this->SetY($this->GetY());
        }
    }

    public function CreateMultiCell($w, $h = 0, $txt = '', $ln = 0, $fontsize = PDF_FONT_SIZE_MAIN, $fontstyle = '', $align = 'L', $font = PDF_FONT_NAME_MAIN)
    {
        $currFontsize = $this->getFontSize();
        $currFontfamily = $this->getFontFamily();
        $currFontstyle = $this->getFontStyle();

        $this->SetFont($font, $fontstyle, $fontsize);

        if (!$h)
        {
            $pdf2 = clone $this;
            $pdf2->setPrintHeader(false);
            $pdf2->setPrintFooter(false);
            $pdf2->AddPage();
            $pdf2->MultiCell($w,$h,$txt,0,$align,false,1,0,0);
            $h = $pdf2->GetY();
            unset($pdf2);
        }

        $this->MultiCell($w,$h,$txt,0,$align,false,$ln);
        if (!$ln)
        {
            $this->SetY($this->GetY()+$h-($this->getFontSize()*$this->getCellHeightRatio()));
        }
//        $this->SetFont($currFontfamily, $currFontstyle, $currFontsize);
    }
}