<?php

/**
 * Contao Open Source CMS
 *
 * Copyright (c) 2005-2015 Leo Feyer
 *
 * @license LGPL-3.0+
 */


/**
 * Register the namespaces
 */
ClassLoader::addNamespaces(array
(
	'eSM_isotope_custom',
));


/**
 * Register the classes
 */
ClassLoader::addClasses(array
(
  // Classes
  'eSM_isotope_custom\Pdf\Document'           => 'system/modules/eSM_isotope_custom/classes/Document.php',
  'eSM_isotope_custom\Pdf\ESMPDF'              => 'system/modules/eSM_isotope_custom/classes/ESMPDF.php',
  'eSM_isotope_custom\Pdf\BBPDF'              => 'system/modules/eSM_isotope_custom/classes/BBPDF.php',
  'eSM_isotope_custom\Pdf\ExpertisePdf'         => 'system/modules/eSM_isotope_custom/classes/ExpertisePdf.php',
  'eSM_isotope_custom\tl_iso_product'  => 'system/modules/eSM_isotope_custom/classes/tl_iso_product.php',

  // Elements
  'eSM_isotope_custom\ContentElement'   => 'system/modules/eSM_isotope_custom/elements/ContentElement.php',

  // Models
  'eSM_isotope_custom\Model\Standard'  => 'system/modules/eSM_isotope_custom/models/Standard.php',
  'eSM_isotope_custom\Model\AffentalerRule'  => 'system/modules/eSM_isotope_custom/models/AffentalerRule.php',
  'eSM_isotope_custom\Model\ProductCollectionSurcharge\AffentalerRule'  => 'system/modules/eSM_isotope_custom/models/ProductCollectionSurcharge/AffentalerRule.php',

  // Modules
  'eSM_isotope_custom\Pdf\ModuleExpertisePdf'  => 'system/modules/eSM_isotope_custom/modules/ModuleExpertisePdf.php',
  'eSM_isotope_custom\Module\CumulativeFilter'  => 'system/modules/eSM_isotope_custom/modules/CumulativeFilter.php',

  // Hooks
  'eSM_isotope_custom\InsertTag'    => 'system/modules/eSM_isotope_custom/hooks/InsertTag.php',
  'eSM_isotope_custom\IsotopeHooks' => 'system/modules/eSM_isotope_custom/hooks/IsotopeHooks.php',
));

/**
 * Register the templates
 */
TemplateLoader::addFiles(array
(
  'iso_payment_sparkasse'                => 'system/modules/isotope/templates/payment',
));