<?php

/**
 * viabook platform for Contao Open Source CMS
 *
 * Copyright (C) 2012-2014 eSalesMedia
 *
 * @package    eSM_viabook
 * @link       http://www.esales-media.de
 * @license    commercial
 *
 * @author     Benjamin Roth <benjamin@esales-media.de>
 */


/**
 * Namespace
 */
namespace eSM_isotope_custom\Pdf;


/**
 * Class ViabookDocuments
 *
 * Generates pdf documents
 * @copyright  eSales Media 2014
 * @author     Benjamin Roth <benjamin@esales-media.de> 
 * @package    eSM_viabook
 */
abstract class Document extends \Controller
{

	/**
	 * ESMPDF
	 * @var ESMPDF
	 */
	protected $objPdf;

	public function __construct($strTcpdfClass='\eSM_isotope_custom\Pdf\ESMPDF')
	{
		parent::__construct();
		if (!class_exists($strTcpdfClass))
		{
			throw new \Exception('Class "'.$strTcpdfClass.'" does not exist');
		}
		$this->objPdf = $this->pdfInit($strTcpdfClass);
	}


	protected function pdfInit($strTcpdfClass)
	{
		// TCPDF configuration
		$l['a_meta_dir'] = 'ltr';
		$l['a_meta_charset'] = $GLOBALS['TL_CONFIG']['characterSet'];
		$l['a_meta_language'] = $GLOBALS['TL_LANGUAGE'];
		$l['w_page'] = 'page';

		// Create new PDF document
		$pdf = new $strTcpdfClass(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true);

		// Set document information
		$pdf->SetCreator(PDF_CREATOR);
		$pdf->SetAuthor(PDF_AUTHOR);
		$pdf->SetTitle("Expertise");
		$pdf->SetSubject("Produkt-Expertise - Baden-Badener Weinhaus GmbH");
		$pdf->SetKeywords("Expertise, Wein, Baden-Baden");
		$pdf->setViewerPreferences(array('PrintScaling'=>'None'));

		// Prevent font subsetting (huge speed improvement)
		$pdf->setFontSubsetting(false);

		// Remove default header/footer
		$pdf->setPrintHeader(false);
		$pdf->setPrintFooter(false);

		// Set margins
		$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
		$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);

		// Reset cell padding
		$pdf->setCellPaddings(0,0,0,0);

		// Set auto page breaks
		$pdf->SetAutoPageBreak(true, PDF_MARGIN_BOTTOM);

		// Set image scale factor
		$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);

		// Set some language-dependent strings
		$pdf->setLanguageArray($l);

		return $pdf;
	}

	private function &pdfObj()
	{
		return $this->objPdf;
	}

	public function pdf()
	{
		return $this->pdfObj();
	}

	abstract public function generate();

}