<?php

/**
 * viabook platform for Contao Open Source CMS
 *
 * Copyright (C) 2012-2014 eSalesMedia
 *
 * @package    eSM_viabook
 * @link       http://www.esales-media.de
 * @license    commercial
 *
 * @author     Benjamin Roth <benjamin@esales-media.de>
 */


/**
 * Namespace
 */
namespace eSM_isotope_custom\Pdf;
use eSM_isotope_custom\Pdf\ESMPDF;

/**
 * Class DocumentOffer
 *
 * Generates pdf documents
 * @copyright  eSales Media 2014
 * @author     Benjamin Roth <benjamin@esales-media.de> 
 * @package    eSM_viabook
 * @property ESMPDF $pdf
 */
class ExpertisePdf extends Document
{

	/**
	 * Document filename
	 * @var string
	 */
	public $documentFilename;

	/**
	 * User Object
	 * @var \FrontendUser object|null
	 */
	protected $User = null;

	/**
	 * Document directory
	 * @var string
	 */
	public $documentDir;

	public function __construct($strTcpdfClass = '\eSM_isotope_custom\Pdf\ESMPDF')
	{
		parent::__construct($strTcpdfClass);

		if (FE_USER_LOGGED_IN)
		{
			$this->User = \FrontendUser::getInstance();
		}

		$this->init();
	}

	function __call($name, $arguments)
	{
		return call_user_func_array(array($this->objPdf,$name),$arguments);
	}

	/**
	 * @param string $name
	 * @return mixed|null|void
	 */
	function __get($name)
	{
		if ($name == 'pdf')
		{
			return $this->pdf();
		}
	}


	protected function init()
	{
		// Add pdf object reference
		$PDF = &$this->objPdf;

		// Remove default header/footer
    $beUserLoggedIn = false;
    /*if(sha1(session_id().(!\Config::get('disableIpCheck') ? \Environment::get('ip') : '').'BE_USER_AUTH') == \Input::cookie('BE_USER_AUTH'))
    {
      $beUserLoggedIn = true;
    }*/
    if (!$beUserLoggedIn)
		{
			$PDF->setPrintHeader(true);
			$PDF->setPrintFooter(true);
		}

		// Initialize document and add a page
		$PDF->AddPage();

		// Set font
		$PDF->setCellHeightRatio(1.5);
		$PDF->SetFont(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA,'','false');
		$PDF->SetFont(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN,'','false');
	}

	public function generate()
	{
		// Add pdf object reference
		$PDF = &$this->objPdf;

		// Close and output PDF document
		$PDF->lastPage();
		if ($this->documentDir)
		{
			$PDF->Output($this->documentDir.'/'.$this->documentFilename, 'F');
		}

		$PDF->Output($this->documentFilename, 'I');
//		$PDF->Output($this->documentFilename, 'D');
	}

}