<?php

/**
 * Isotope eCommerce for Contao Open Source CMS
 *
 * Copyright (C) 2009-2014 terminal42 gmbh & Isotope eCommerce Workgroup
 *
 * @package    Isotope
 * @link       http://isotopeecommerce.org
 * @license    http://opensource.org/licenses/lgpl-3.0.html
 */

namespace eSM_isotope_custom\Model;

use Haste\Util\Url;

/**
 * Standard implementation of an Isotope product.
 */
class Standard extends \Isotope\Model\Product\Standard
{
  /**
   * Generate url
   *
   * @param \PageModel $objJumpTo A PageModel instance
   *
   * @return string
   *
   * @throws \InvalidArgumentException
   */
  public function generateUrl(\PageModel $objJumpTo = null)
  {
    $strUrl = parent::generateUrl($objJumpTo);

    if (\Input::get('isorc') !== null)
    {
      $strUrl = Url::addQueryString(
        http_build_query(array('isorc' => \Input::get('isorc'))),
        $strUrl
      );
    }
    return $strUrl;
  }

  public function generate(array $arrConfig)
  {

    $arrButtons = array();
    foreach ($arrConfig['buttons'] as $button)
    {
      if ($button == 'add_to_cart' && $this->not_buyable)
      {
        continue;
      }
      $arrButtons[] = $button;
    }
    $arrConfig['buttons'] = $arrButtons;

    return parent::generate($arrConfig);
  }


}
