<?php

/**
 * Isotope eCommerce for Contao Open Source CMS
 *
 * Copyright (C) 2009-2016 terminal42 gmbh & Isotope eCommerce Workgroup
 *
 * @link       https://isotopeecommerce.org
 * @license    https://opensource.org/licenses/lgpl-3.0.html
 */

namespace eSM_isotope_custom\Model;

use Isotope\Interfaces\IsotopeProduct;
use Isotope\Model\Rule;

/**
 * @property int    $id
 * @property int    $tstamp
 * @property string $type
 * @property string $name
 * @property string $label
 * @property string $discount
 * @property int    $tax_class
 * @property string $applyTo
 * @property string $rounding
 * @property bool   $enableCode
 * @property string $code
 * @property int    $limitPerMember
 * @property int    $limitPerConfig
 * @property int    $minSubtotal
 * @property int    $maxSubtotal
 * @property string $minWeight
 * @property string $maxWeight
 * @property int    $minItemQuantity
 * @property int    $maxItemQuantity
 * @property string $quantityMode
 * @property int    $startDate
 * @property int    $endDate
 * @property int    $startTime
 * @property int    $endTime
 * @property string $configRestrictions
 * @property bool   $configCondition
 * @property string $memberRestrictions
 * @property bool   $memberCondition
 * @property string $productRestrictions
 * @property bool   $productCondition
 * @property string $attributeName
 * @property string $attributeCondition
 * @property string $attributeValue
 * @property bool   $enabled
 */
class AffentalerRule extends Rule
{
  public static function findByProduct(IsotopeProduct $objProduct, $strField, $fltPrice)
  {
      return static::findByConditions(array("type='affentaler'"), array(), array($objProduct), ($strField == 'low_price' ? true : false), array($strField => $fltPrice));
  }

  public static function findForCart($intId = null)
  {
    $arrProcedures = array("type='special'", "enableCode=''");

    if (null === $intId) {
      $arrProcedures[] = "groupOnly=''";
    } else {
      $arrProcedures[] = 'id='.(int)$intId;
    }

    return static::findByConditions($arrProcedures);
  }
}
