<?php

/**
 * This file is part of contao-weinanlieferung-bundle.
 *
 * (c) vonRotenberg
 *
 * @license commercial
 */

use Contao\CoreBundle\DataContainer\PaletteManipulator;

// Extend the default palette
PaletteManipulator::create()
    ->addLegend('luumicore_legend', 'imageSizes_legend', PaletteManipulator::POSITION_AFTER)
    ->addField(array('standorts','reservationp'), 'luumicore_legend', PaletteManipulator::POSITION_APPEND)
    ->applyToPalette('default', 'tl_user_group')
;

// Add fields to tl_user_group
$GLOBALS['TL_DCA']['tl_user_group']['fields']['standorts'] = array
(
    'exclude'                 => true,
    'inputType'               => 'checkbox',
    'foreignKey'              => 'tl_vr_wa_standort.title',
    'eval'                    => array('multiple'=>true),
    'sql'                     => "blob NULL"
);

$GLOBALS['TL_DCA']['tl_user_group']['fields']['reservationp'] = array
(
    'exclude'               => true,
    'filter'                => true,
    'options'               => array('edit', 'delete'),
    'eval'                  => array('multiple'=>true),
    'reference'             => &$GLOBALS['TL_LANG']['MSC'],
    'inputType'             => 'checkbox',
    'sql'                   => "blob NULL"

);
