<?php

namespace vonRotenberg\WeinanlieferungBundle\Event;

use Symfony\Contracts\EventDispatcher\Event;
use vonRotenberg\WeinanlieferungBundle\Model\WeinanlieferungReservationModel;

/**
 * Event that is triggered when a check-in is completed.
 */
class CheckInCompletedEvent extends Event
{
    /**
     * Event name
     */
    public const NAME = 'vonrotenberg.weinanlieferung.checkin_completed';

    /**
     * @var array The reservation data
     */
    private $reservationData;

    /**
     * @var WeinanlieferungReservationModel The reservation model
     */
    private $reservationModel;

    /**
     * CheckInCompletedEvent constructor.
     *
     * @param array $reservationData The reservation data as array
     * @param WeinanlieferungReservationModel $reservationModel The reservation model
     */
    public function __construct(array $reservationData, WeinanlieferungReservationModel $reservationModel)
    {
        $this->reservationData = $reservationData;
        $this->reservationModel = $reservationModel;
    }

    /**
     * Get the reservation data.
     *
     * @return array
     */
    public function getReservationData(): array
    {
        return $this->reservationData;
    }

    /**
     * Get the reservation model.
     *
     * @return WeinanlieferungReservationModel
     */
    public function getReservationModel(): WeinanlieferungReservationModel
    {
        return $this->reservationModel;
    }
}
