<?php

declare(strict_types=1);

/*
 * This file is part of contao-weinanlieferung-bundle.
 *
 * (c) vonRotenberg
 *
 * @license commercial
 */

namespace vonRotenberg\WeinanlieferungBundle\EventListener\DataContainer;

use Contao\CoreBundle\ServiceAnnotation\Callback;
use Contao\DataContainer;
use Doctrine\DBAL\Connection;
use Symfony\Contracts\Translation\TranslatorInterface;

class WeinanlieferungUnitsContainerListener
{
    /** @var Connection */
    protected $db;

    private TranslatorInterface $translator;

    public function __construct(Connection $db, TranslatorInterface $translator)
    {
        $this->db = $db;
        $this->translator = $translator;
    }

    /**
     * @Callback(table="tl_vr_wa_units", target="list.label.label")
     */
    public function onNcNotificationOptionsCallback(array $row, string $label, DataContainer $dc, array $labels): array
    {
        $fieldName = 'title';
        $fields = $GLOBALS['TL_DCA'][$dc->table]['list']['label']['fields'];
        $key = array_search($fieldName, $fields, true);

        $labels[$key] .= ' ('.$row['containers'].' '.$this->translator->trans('tl_vr_wa_units.containers.0', [], 'contao_tl_vr_wa_units').')';

        return $labels;
    }
}
