<?php

declare(strict_types=1);

/*
 * This file is part of contao-weinanlieferung-bundle.
 *
 * (c) vonRotenberg
 *
 * @license commercial
 */

namespace vonRotenberg\WeinanlieferungBundle\EventListener\DataContainer;

use Contao\CoreBundle\ServiceAnnotation\Callback;
use Contao\DataContainer;
use Contao\Date;
use Contao\StringUtil;
use Doctrine\DBAL\Connection;
use vonRotenberg\WeinanlieferungBundle\Model\WeinanlieferungLeseartModel;
use vonRotenberg\WeinanlieferungBundle\Model\WeinanlieferungRebsorteModel;
use vonRotenberg\WeinanlieferungBundle\Model\WeinanlieferungSlotsModel;

class WeinanlieferungReservationContainerListener
{
    /** @var Connection */
    protected $db;

    public function __construct(Connection $db)
    {
        $this->db = $db;
    }


    /**
     * @Callback(table="tl_vr_wa_reservation", target="fields.sorten.options")
     */
    public function onSortenOptionsCallback(DataContainer $dc)
    {
        $arrSorten = [];

        if (($Slot = WeinanlieferungSlotsModel::findByPk($dc->activeRecord->pid)) === null)
        {
            return $arrSorten;
        }

        $Sorten = StringUtil::deserialize($Slot->sorten,true);
        foreach($Sorten as $sorte)
        {
            $objSorte = WeinanlieferungRebsorteModel::findByPk($sorte['sorte']);
            $objLeseart = WeinanlieferungLeseartModel::findByPk($sorte['leseart']);
            $arrSorten[$objSorte->id.','.$objLeseart->id] = ($objSorte !== null  ? $objSorte->title : '') . ' ' . ($objLeseart !== null  ? $objLeseart->title : '');
        }

        return $arrSorten;
    }

    /**
     * @Callback(table="tl_vr_wa_reservation", target="fields.pid.options")
     */
    public function onPidOptionsCallback(DataContainer $dc)
    {
        if (($Slots = WeinanlieferungSlotsModel::findAllFuturePublished()) === null)
        {
            return [];
        }

        $arrData = [];
        foreach ($Slots as $slot)
        {
            $arrData[$slot->id] = Date::parse(Date::getNumericDatimFormat(),$slot->time);
        }

        return $arrData;
    }
}
