<?php

/**
 * This file is part of contao-weinanlieferung-bundle.
 *
 * (c) vonRotenberg
 *
 * @license commercial
 */

use Contao\DC_Table;
use Contao\DataContainer;

\Contao\System::loadLanguageFile('default');

$GLOBALS['TL_DCA']['tl_vr_wa_slotassistant'] =
    [

        // Config
        'config' =>
            [
                'dataContainer' => DC_Table::class,
                'sql'           =>
                    [
                        'keys' =>
                            [
                                'id' => 'primary',
                            ]
                    ]
            ],

        // Fields
        'fields' =>
            [
                'id'        => [
                    'sql' => "int(10) unsigned NOT NULL auto_increment"
                ],
                'tstamp'    => [
                    'sql' => "int(10) unsigned NOT NULL default '0'"
                ],
                'timeframe' => [
                    'inputType' => 'multiColumnWizard',
                    'eval' => [
                        'minCount' => 1,
                        'columnFields' =>
                        [
                            'sorte' =>
                                [
                                    'label' => $GLOBALS['TL_LANG']['MSC']['wa_sorte'],
                                    'inputType' => 'select',
                                    'foreignKey'   => 'tl_vr_wa_rebsorte.title',
                                    'eval' => ['style' => 'width:350px', 'mandatory' => true, 'chosen' =>true, 'includeBlankOption' => true]
                                ],
                            'leseart' =>
                                [
                                    'label' => $GLOBALS['TL_LANG']['MSC']['wa_leseart'],
                                    'inputType' => 'select',
                                    'foreignKey'   => 'tl_vr_wa_leseart.title',
                                    'eval' => ['style' => 'width:350px', 'mandatory' => true, 'chosen' =>true, 'includeBlankOption' => true]
                                ]
                        ]
                    ],
                    'sql'       => 'blob NULL'
                ]
            ]
    ];
