<?php

declare(strict_types=1);

/*
 * This file is part of contao-weinanlieferung-bundle.
 *
 * (c) vonRotenberg
 *
 * @license commercial
 */

namespace vonRotenberg\WeinanlieferungBundle\EventListener\DataContainer;

use Contao\CoreBundle\ServiceAnnotation\Callback;
use Contao\DataContainer;
use Contao\Date;
use Contao\StringUtil;
use Doctrine\DBAL\Connection;
use vonRotenberg\WeinanlieferungBundle\Model\WeinanlieferungLeseartModel;
use vonRotenberg\WeinanlieferungBundle\Model\WeinanlieferungRebsorteModel;
use vonRotenberg\WeinanlieferungBundle\Model\WeinanlieferungSlotsModel;

class WeinanlieferungSlotContainerListener
{
    /** @var Connection */
    protected $db;

    public function __construct(Connection $db)
    {
        $this->db = $db;
    }


    /**
     * @Callback(table="tl_vr_wa_slot", target="list.sorting.child_record")
     */
    public function onChildRecordCallback(array $row)
    {
        $Slot = WeinanlieferungSlotsModel::findByPk($row['id']);

        $arrSorten = [];

        $Sorten = StringUtil::deserialize($Slot->sorten,true);
        foreach($Sorten as $sorte)
        {
            $objSorte = WeinanlieferungRebsorteModel::findByPk($sorte['sorte']);
            $objLeseart = WeinanlieferungLeseartModel::findByPk($sorte['leseart']);
            $arrSorten[] = ($objSorte !== null  ? $objSorte->title : '') . ' ' . ($objLeseart !== null  ? $objLeseart->title : '');
        }

        return sprintf('<div class="tl_content_left"><div class="row u-items-center">
            <div class="col-2 text-md">%s %s</div>
            <div class="col-3">
              <div class="t-label">Behälterkapazität</div>%s
            </div>
            <div class="col-3">
              <div class="t-label">Sorten</div>%s
            </div>
        </div></div>',Date::parse(Date::getNumericDateFormat(),$row['date']), Date::parse(Date::getNumericTimeFormat(),$row['time']),$Slot->behaelter,implode(', ',$arrSorten));
    }

    /**
     * @Callback(table="tl_vr_wa_slot", target="config.onsubmit")
     */
    public function adjustTime(DataContainer $dc)
    {
        // Return if there is no active record (override all) or no start date has been set yet
        if (!$dc->activeRecord || empty($dc->activeRecord->date))
        {
            return;
        }

        $arrSet['time'] = strtotime(date('Y-m-d', $dc->activeRecord->date) . ' ' . date('H:i:s', $dc->activeRecord->time));

        $this->db->update("tl_vr_wa_slot",$arrSet,['id' => $dc->id]);
    }
}
