<?php

/**
 * This file is part of contao-weinanlieferung-bundle.
 *
 * (c) vonRotenberg
 *
 * @license commercial
 */

use Contao\DC_Table;
use Contao\DataContainer;

\Contao\System::loadLanguageFile('default');

$GLOBALS['TL_DCA']['tl_vr_wa_slot'] = array
(

    // Config
    'config' => array
    (
        'dataContainer'    => DC_Table::class,
        'ptable'           => 'tl_vr_wa_standort',
        'sql'              => array
        (
            'keys' => array
            (
                'id' => 'primary',
                'pid' => 'index'
            )
        )
    ),

    // List
    'list' => array
    (
        'sorting' => array
        (
            'mode' => DataContainer::MODE_PARENT,
            'fields' => array('time'),
            'headerFields' => array('title'),
//            'disableGrouping' => true,
            'panelLayout' => 'filter;sort,limit',
        ),
        'global_operations' => array
        (
            'all' => array
            (
                'href'                => 'act=select',
                'class'               => 'header_edit_all',
                'attributes'          => 'onclick="Backend.getScrollOffset()" accesskey="e"'
            )
        ),
        'operations' => array
        (
            'edit' => array
            (
                'href'                => 'act=edit',
                'icon'                => 'edit.gif',
            ),
            'copy' => array
            (
                'href'                => 'act=paste&amp;mode=copy',
                'icon'                => 'copy.svg'
            ),
            'cut' => array
            (
                'href'                => 'act=paste&amp;mode=cut',
                'icon'                => 'cut.svg',
                'attributes'          => 'onclick="Backend.getScrollOffset()"'
            ),
            'delete' => array
            (
                'href'                => 'act=delete',
                'icon'                => 'delete.gif',
            ),
            'toggle' => array
            (
                'href'                => 'act=toggle&amp;field=published',
                'icon'                => 'visible.svg',
                'showInHeader'        => true
            ),
            'show' => array
            (
                'icon'                => 'show.gif',
            ),
        )
    ),

    // Palettes
    'palettes' => array
    (
        '__selector__' => array('addEnclosure'),
        'default' => '{time_legend},date,time;{type_legend},behaelter,sorten,lage,ernteart;{info_legend},anmerkungen,addEnclosure;{booking_legend},published,buchbar_ab,buchbar_bis'
    ),

    // Subpalettes
    'subpalettes' => array
    (
        'addEnclosure' => 'enclosure'
    ),

    // Fields
    'fields' => array
    (
        'id'          => array
        (
            'sql' => "int(10) unsigned NOT NULL auto_increment"
        ),
        'pid'         => array
        (
            'foreignKey' => 'tl_vr_wa_standort.title',
            'sql'        => "int(10) unsigned NOT NULL default '0'",
            'relation'   => array('type' => 'belongsTo', 'load' => 'lazy')
        ),
        'tstamp'      => array
        (
            'sql' => "int(10) unsigned NOT NULL default '0'"
        ),
        'nc_sent'      => array
        (
            'sql' => "int(10) unsigned NOT NULL default '0'"
        ),

        'date'        => array
        (
            'exclude'   => true,
            'filter'    => true,
            'flag'      => DataContainer::SORT_MONTH_ASC,
            'inputType' => 'text',
            'eval'      => array('rgxp' => 'date', 'mandatory' => true, 'datepicker' => true, 'tl_class' => 'w50 wizard'),
            'sql'       => "int(10) unsigned NULL"
        ),
        'time'        => array
        (
            'exclude'   => true,
            'filter'    => true,
            'default'   => time(),
            'sorting'   => true,
            'flag'      => DataContainer::SORT_DAY_ASC,
            'inputType' => 'text',
            'eval'      => array('rgxp' => 'time', 'mandatory' => true, 'tl_class' => 'w50'),
            'sql'       => "int(10) NULL"
        ),
        'lage'   => array
        (
            'exclude'   => true,
            'inputType' => 'checkbox',
            'foreignKey'   => 'tl_vr_wa_lage.title',
            'eval'      => array('mandatory' => true, 'multiple' => true, 'csv'=>',','tl_class' => 'w50'),
            'sql'       => "blob NULL",
            'relation'   => array('type' => 'hasMany', 'load' => 'lazy')
        ),
        'behaelter'   => array
        (
            'exclude'   => true,
            'inputType' => 'select',
            'options_callback'   => function () {
                $range = [];
                for ($i = 1; $i <= 30; $i++)
                {
                    $range[] = $i;
                }
                return $range;
            },
            'eval'      => array('rgxp' => 'natural', 'mandatory' => true, 'includeBlankOption' => true, 'tl_class' => 'w50'),
            'sql'       => "smallint(3) unsigned NOT NULL default 0"
        ),
        'sorten'       => array
        (
            'exclude'   => true,
            'inputType' => 'multiColumnWizard',
            'eval'      => array(
                'minCount' => 1,
                'tl_class' => 'clr',
                'columnFields' => array
                (
                    'sorte' => array
                    (
                        'label' => $GLOBALS['TL_LANG']['MSC']['wa_sorte'],
                        'inputType' => 'select',
                        'foreignKey'   => 'tl_vr_wa_rebsorte.title',
                        'eval' => array('style' => 'width:350px','mandatory' => true,'chosen'=>true,'includeBlankOption' => true)
                    ),
                    'leseart' => array
                    (
                        'label' => $GLOBALS['TL_LANG']['MSC']['wa_leseart'],
                        'inputType' => 'select',
                        'foreignKey'   => 'tl_vr_wa_leseart.title',
                        'eval' => array('style' => 'width:350px','mandatory' => true,'chosen'=>true,'includeBlankOption' => true)
                    )
                )
            ),
            'sql'       => "blob NULL",
        ),
        'ernteart' => array
        (
            'exclude'                 => true,
            'inputType'               => 'checkbox',
            'options'                 => array('handlese','vollernter'),
            'eval'                    => array('mandatory'=>true,'multiple'=>true,'csv'=>',', 'tl_class'=>'w50'),
            'reference'               => $GLOBALS['TL_LANG']['REF']['wa_ernteart'],
            'sql'                     => "blob NULL"
        ),
        'anmerkungen' => array
        (
            'exclude'                 => true,
            'search'                  => true,
            'inputType'               => 'textarea',
            'eval'                    => array('rte'=>'tinyMCE', 'tl_class'=>'clr'),
            'sql'                     => "text NULL"
        ),
        'addEnclosure' => array
        (
            'exclude'                 => true,
            'inputType'               => 'checkbox',
            'eval'                    => array('submitOnChange'=>true),
            'sql'                     => "char(1) NOT NULL default ''"
        ),
        'enclosure' => array
        (
            'exclude'                 => true,
            'inputType'               => 'fileTree',
            'eval'                    => array('multiple'=>true, 'fieldType'=>'checkbox', 'filesOnly'=>true, 'isDownloads'=>true, 'extensions'=>Config::get('allowedDownload'), 'mandatory'=>true, 'isSortable'=>true),
            'sql'                     => "blob NULL"
        ),
        'published'     => array
        (
            'exclude'   => true,
            'toggle'    => true,
            'filter'    => true,
            'default'   => '1',
            'flag'      => DataContainer::SORT_INITIAL_LETTER_DESC,
            'inputType' => 'checkbox',
            'eval'      => array('doNotCopy' => true),
            'sql'       => "char(1) NOT NULL default ''"
        ),
        'buchbar_ab' => array
        (
            'exclude'   => true,
            'inputType' => 'text',
            'eval'      => array('rgxp' => 'datim', 'datepicker' => true, 'tl_class' => 'clr w50 wizard'),
            'sql'       => "int(10) unsigned NULL"
        ),
        'buchbar_bis' => array
        (
            'exclude'   => true,
            'inputType' => 'text',
            'eval'      => array('rgxp' => 'datim', 'mandatory' => true, 'datepicker' => true, 'tl_class' => 'w50 wizard'),
            'sql'       => "int(10) unsigned NULL"
        ),
    )
);
