<?php

declare(strict_types=1);

/*
 * This file is part of contao-weinanlieferung-bundle.
 *
 * (c) vonRotenberg
 *
 * @license commercial
 */

namespace vonRotenberg\WeinanlieferungBundle\Controller\Backend;

use Contao\Config;
use Contao\CoreBundle\Controller\AbstractController;
use Contao\CoreBundle\Csrf\ContaoCsrfTokenManager;
use Contao\Date;
use Contao\Environment;
use Contao\FrontendUser;
use Contao\Image;
use Contao\Input;
use Contao\SelectMenu;
use Contao\StringUtil;
use Contao\System;
use Contao\TextField;
use Contao\Widget;
use Doctrine\DBAL\Connection;
use Symfony\Component\HttpFoundation\RequestStack;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;
use Twig\Environment as TwigEnvironment;
use vonRotenberg\WeinanlieferungBundle\Model\WeinanlieferungLeseartModel;
use vonRotenberg\WeinanlieferungBundle\Model\WeinanlieferungRebsorteModel;
use vonRotenberg\WeinanlieferungBundle\Model\WeinanlieferungReservationModel;
use vonRotenberg\WeinanlieferungBundle\Model\WeinanlieferungSlotsModel;

/**
 * @Route("%contao.backend.route_prefix%/weinanlieferung/slotassistant", name=self::class, defaults={"_scope" = "backend"})
 */
class WeinanlieferungSlotAssistantController extends AbstractController
{
    private $twig;
    private $tokenManager;
    private $request;
    private $db;

    protected $fields;

    public function __construct(TwigEnvironment $twig, ContaoCsrfTokenManager $tokenManager, RequestStack $requestStack, Connection $db)
    {
        $this->twig = $twig;
        $this->tokenManager = $tokenManager;
        $this->request = $requestStack->getCurrentRequest();
        $this->db = $db;

        $container = System::getContainer();
        $objSession = $container->get('session');


        $strKey = Input::get('popup') ? 'popupReferer' : 'referer';
        $strRefererId = $this->request->attributes->get('_contao_referer_id');

        $session = $objSession->get($strKey);
        $session[$strRefererId]['current'] = substr(Environment::get('requestUri'), \strlen(Environment::get('path')) + 1);
        $objSession->set($strKey, $session);
    }

    public function __invoke(): Response
    {
        $GLOBALS['TL_CSS']['cirrus'] = 'bundles/vonrotenbergweinanlieferung/css/backend.css|static';
        $arrData = [
            'request_token' => $this->tokenManager->getDefaultTokenValue(),
            'ref'           => $this->request->attributes->get('_contao_referer_id')
        ];
        System::loadLanguageFile('default');

//        dump($this->getWidgets());

        $arrData['fields'] = $this->getWidgets();

        return new Response(
            $this->twig->render(
                '@Contao_VonrotenbergWeinanlieferungBundle/be_wa_slotassistant.html.twig',
                $arrData
            )
        );
    }

    protected function getWidgets()
    {
        if (!empty($this->fields))
        {
            return $this->fields;
        }

        $arrWidgets = [
            'base_legend' => [
                [
                    'class'  => 'w50',
                    'help'   => 'Legen Sie hier den Zeitslot-Typ/Annahmestelle fest.',
                    'widget' => new SelectMenu([
                        'name'      => 'slotType',
                        'mandatory' => true,
                        'options'   => [
                            ['value' => 'eins', 'label' => 'eins'],
                            ['value' => 'zwei', 'label' => 'zwei']
                        ],
                        'label'     => 'Zeitslot-Typ'
                    ])
                ],
                [
                    'class'  => 'w50',
                    'help'   => 'Die Pufferzeit zwischen den Slots.',
                    'widget' => new TextField([
                        'name'      => 'buffer',
                        'mandatory' => true,
                        'label'     => 'Pufferzeit in min.',
                        'rgxp'      => 'natural'
                    ])
                ]
            ],
            'time_legend' => [
                [
                    'class'  => 'w50 wizard',
                    'help'   => 'Zeitslot-Typ/Annahmestelle fest.',
                    'widget' => new TextField([
                        'name'       => 'date_start[1]',
                        'mandatory'  => true,
                        'label'      => 'Pufferzeit in min.',
                        'rgxp'       => 'datim',
                        'datepicker' => true,
                    ])
                ]
            ]
        ];


        foreach ($arrWidgets as $group => $fields)
        {
            foreach ($fields as $field)
            {
                if (empty($field['widget']->id))
                {
                    $field['widget']->id = $field['widget']->name;
                }

                $wizard = '';

                // Date picker
                if ($field['widget']->datepicker ?? null)
                {
                    $rgxp = $field['widget']->rgxp ?? 'date';
                    $format = Date::formatToJs(Config::get($rgxp . 'Format'));

                    switch ($rgxp)
                    {
                        case 'datim':
                            $time = ",\n        timePicker: true";
                            break;

                        case 'time':
                            $time = ",\n        pickOnly: \"time\"";
                            break;

                        default:
                            $time = '';
                            break;
                    }

                    $strOnSelect = '';

                    // Trigger the auto-submit function (see #8603)
                    if ($field['widget']->submitOnChange ?? null)
                    {
                        $strOnSelect = ",\n        onSelect: function() { Backend.autoSubmit(\"wa_slotassistant\"); }";
                    }

                    $wizard .= ' ' . Image::getHtml('assets/datepicker/images/icon.svg', '', 'title="' . StringUtil::specialchars($GLOBALS['TL_LANG']['MSC']['datepicker']) . '" id="toggle_' . $field['widget']->id . '" style="cursor:pointer"') . '
  <script>
    window.addEvent("domready", function() {
      new Picker.Date($("ctrl_' . $field['widget']->id . '"), {
        draggable: false,
        toggle: $("toggle_' . $field['widget']->id . '"),
        format: "' . $format . '",
        positionOffset: {x:-211,y:-209}' . $time . ',
        pickerClass: "datepicker_bootstrap",
        useFadeInOut: !Browser.ie' . $strOnSelect . ',
        startDay: ' . $GLOBALS['TL_LANG']['MSC']['weekOffset'] . ',
        titleFormat: "' . $GLOBALS['TL_LANG']['MSC']['titleFormat'] . '"
      });
    });
  </script>';
                    $field['widget']->wizard = $wizard;
                }

                if (Input::post('FORM_SUBMIT') == 'wa_slotassistant')
                {
                    dump($field['widget']->validate());
                }
            }
        }

        $this->fields = $arrWidgets;
        return $this->fields;
    }
}
