<?php

/**
 * This file is part of contao-weinanlieferung-bundle.
 *
 * (c) vonRotenberg
 *
 * @license commercial
 */

use Contao\DC_Table;
use Contao\DataContainer;

\Contao\System::loadLanguageFile('default');
\Contao\System::loadLanguageFile('tl_vr_wa_slotassistant');

$GLOBALS['TL_DCA']['tl_vr_wa_slotassistant'] =
    [

        // Config
        'config' =>
            [
                'dataContainer' => DC_Table::class,
                'sql'           =>
                    [
                        'keys' =>
                            [
                                'id' => 'primary',
                            ]
                    ]
            ],

        // Fields
        'fields' =>
            [
                'id'        => [
                    'sql' => "int(10) unsigned NOT NULL auto_increment"
                ],
                'tstamp'    => [
                    'sql' => "int(10) unsigned NOT NULL default '0'"
                ],
                'timeframe' => [
                    'inputType' => 'multiColumnWizard',
                    'eval' => [
                        'minCount' => 1,
                        'columnFields' =>
                        [
                            'date_start' =>
                                [
                                    'label' => $GLOBALS['TL_LANG']['tl_vr_wa_slotassistant']['date_start'],
                                    'inputType' => 'text',
                                    'eval' => [
                                        'style' => 'width:150px',
                                        'mandatory' => true,
                                        'rgxp' =>'datim',
                                        'datepicker' => true
                                    ]
                                ],
                            'date_end' =>
                                [
                                    'label' => $GLOBALS['TL_LANG']['tl_vr_wa_slotassistant']['date_end'],
                                    'inputType' => 'text',
                                    'eval' => [
                                        'style' => 'width:150px',
                                        'mandatory' => true,
                                        'rgxp' =>'datim',
                                        'datepicker' => true
                                    ]
                                ]
                        ]
                    ],
                    'sql'       => 'blob NULL'
                ],
                'enclosure' => [
                    'exclude'                 => true,
                    'inputType'               => 'fileTree',
                    'eval'                    => ['multiple' =>true, 'fieldType' =>'checkbox', 'filesOnly' =>true, 'isDownloads' =>true, 'extensions' =>Config::get('allowedDownload'), 'mandatory' =>true, 'isSortable' =>true],
                    'sql'                     => "blob NULL"
                ],
            ]
    ];
