<?php

declare(strict_types=1);

/*
 * This file is part of eSales Media SinglereisenBundle
 *
 * (c) Benjamin Roth
 *
 * @license proprietary
 */

namespace vonRotenberg\WeinanlieferungBundle\Command;

use Contao\CoreBundle\Framework\ContaoFramework;
use Contao\System;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;
use vonRotenberg\WeinanlieferungBundle\Cron\SendSlotChangeNotificationJob;

class SendSlotChangeNotificationCommand extends Command
{
    public function __construct(ContaoFramework $framework)
    {
        $this->framework = $framework;

        parent::__construct();
    }

    protected function configure(): void
    {
        $this
            ->setName('luumicore:sendSlotNotifications')
            ->setDescription('Sends notifications about newly added or modified slots once they\'re bookable.')
        ;
    }

    protected function execute(InputInterface $input, OutputInterface $output): int
    {
        $this->framework->initialize();

        /** @var SendSlotChangeNotificationJob $wa_service */
        $wa_service = System::getContainer()->get("vonrotenberg.cron.wa_slot_notifications");

        $wa_service('cli');

        return 0;
    }
}
