<?php

declare(strict_types=1);

/*
 * This file is part of eSales Media SinglereisenBundle
 *
 * (c) Benjamin Roth
 *
 * @license proprietary
 */

namespace vonRotenberg\WeinanlieferungBundle\Command;

use Contao\CoreBundle\Framework\ContaoFramework;
use Contao\System;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\EventDispatcher\EventDispatcherInterface;
use vonRotenberg\WeinanlieferungBundle\Cron\AutoCheckInJob;

class AutoCheckInCommand extends Command
{
    private $framework;
    private $eventDispatcher;

    public function __construct(ContaoFramework $framework, EventDispatcherInterface $eventDispatcher)
    {
        $this->framework = $framework;
        $this->eventDispatcher = $eventDispatcher;

        parent::__construct();
    }

    protected function configure(): void
    {
        $this
            ->setName('luumicore:autoCheckIn')
            ->setDescription('Automatically check in all open bookings within a defined time threshold before the slot time.')
        ;
    }

    protected function execute(InputInterface $input, OutputInterface $output): int
    {
        $this->framework->initialize();

        /** @var AutoCheckInJob $wa_service */
        $wa_service = System::getContainer()->get("vonrotenberg.cron.wa_auto_checkin");

        $wa_service('cli');

        return 0;
    }
}
