<?php

/**
 * This file is part of contao-weinanlieferung-bundle.
 *
 * (c) vonRotenberg
 *
 * @license commercial
 */

use vonRotenberg\WeinanlieferungBundle\Model\WeinanlieferungLageModel;
use vonRotenberg\WeinanlieferungBundle\Model\WeinanlieferungRebsorteModel;
use vonRotenberg\WeinanlieferungBundle\Model\WeinanlieferungLeseartModel;
use vonRotenberg\WeinanlieferungBundle\Model\WeinanlieferungReservationModel;
use vonRotenberg\WeinanlieferungBundle\Model\WeinanlieferungSlotsModel;
use vonRotenberg\WeinanlieferungBundle\Model\WeinanlieferungStandortModel;
use vonRotenberg\WeinanlieferungBundle\Model\WeinanlieferungUnitModel;
use Contao\ArrayUtil;

ArrayUtil::arrayInsert($GLOBALS['BE_MOD'],1,[
    'weinanlieferung' => [
        'weinanlieferung' => [
            'tables'     => array('tl_vr_wa_standort', 'tl_vr_wa_slot', 'tl_vr_wa_rebsorte','tl_vr_wa_leseart','tl_vr_wa_lage','tl_vr_wa_reservation'),
            'stylesheet' => array('bundles/vonrotenbergweinanlieferung/css/backend.css')
        ],
        'wa_units' => [
            'tables'     => array('tl_vr_wa_unit'),
            'stylesheet' => array('bundles/vonrotenbergweinanlieferung/css/backend.css')
        ],
    ]
]);


$GLOBALS['TL_MODELS']['tl_vr_wa_slot'] = WeinanlieferungSlotsModel::class;
$GLOBALS['TL_MODELS']['tl_vr_wa_standort'] = WeinanlieferungStandortModel::class;
$GLOBALS['TL_MODELS']['tl_vr_wa_rebsorte'] = WeinanlieferungRebsorteModel::class;
$GLOBALS['TL_MODELS']['tl_vr_wa_leseart'] = WeinanlieferungLeseartModel::class;
$GLOBALS['TL_MODELS']['tl_vr_wa_lage'] = WeinanlieferungLageModel::class;
$GLOBALS['TL_MODELS']['tl_vr_wa_reservation'] = WeinanlieferungReservationModel::class;
$GLOBALS['TL_MODELS']['tl_vr_wa_unit'] = WeinanlieferungUnitModel::class;


// Notification
$GLOBALS['NOTIFICATION_CENTER']['NOTIFICATION_TYPE']['weinanlieferung']['wa_booking_change'] = array
(
    'recipients'    => array
    (
        'member_email', // The email address of the recipient
        'admin_email' // The email address of the recipient
    ),
    'email_sender_address'    => array
    (
        'member_email', // The email address of the recipient
        'admin_email' // The email address of the recipient
    ),
    'email_sender_name'    => array
    (
        'member_email', // The email address of the recipient
        'admin_email' // The email address of the recipient
    ),
    'email_subject'        => array
    (
        'domain',
        'member_email',
        'admin_email',
        'slot_date',
        'slot_time',
        'slot_standort',
        'booking_ncsent',
        'booking_approved',
        'booking_approved_on',
    ),
    'email_text'    => array
    (
        'member_firstname', // The firstname of the recipient
        'member_lastname', // The lastname of the recipient
        'member_memberno', // The member account number of the recipient
        'slot_date',
        'slot_time',
        'slot_standort',
        'slot_behaelter',
        'slot_sorten',
        'slot_ernteart',
        'slot_lage',
        'slot_anmerkungen',
        'booking_ncsent',
        'booking_behaelter',
        'booking_unit_name',
        'booking_unit_amount',
        'booking_sorten',
        'booking_ernteart',
        'booking_lage',
        'booking_approved',
        'booking_approved_on',
    ),
    'email_html'    => array
    (
        'member_firstname', // The firstname of the recipient
        'member_lastname', // The lastname of the recipient
        'member_memberno', // The member account number of the recipient
        'slot_date',
        'slot_time',
        'slot_standort',
        'slot_behaelter',
        'slot_sorten',
        'slot_ernteart',
        'slot_lage',
        'slot_anmerkungen',
        'booking_ncsent',
        'booking_behaelter',
        'booking_unit_name',
        'booking_unit_amount',
        'booking_sorten',
        'booking_ernteart',
        'booking_lage',
        'booking_approved',
        'booking_approved_on',
    )
);

$GLOBALS['NOTIFICATION_CENTER']['NOTIFICATION_TYPE']['weinanlieferung']['wa_slot_change'] = array
(
    'recipients'    => array
    (
        'member_email', // The email address of the recipient
        'admin_email' // The email address of the recipient
    ),
    'email_sender_address'    => array
    (
        'member_email', // The email address of the recipient
        'admin_email' // The email address of the recipient
    ),
    'email_sender_name'    => array
    (
        'member_email', // The email address of the recipient
        'admin_email' // The email address of the recipient
    ),
    'email_subject'        => array
    (
        'domain',
        'member_email',
        'admin_email',
        'slot_date',
        'slot_time',
        'slot_standort',
        'slot_ncsent',
        'slot_behaelter',
        'slot_behaelterBuchbar',
    ),
    'email_text'    => array
    (
        'member_firstname', // The firstname of the recipient
        'member_lastname', // The lastname of the recipient
        'member_memberno', // The member account number of the recipient
        'slot_date',
        'slot_time',
        'slot_standort',
        'slot_behaelter',
        'slot_behaelterBuchbar',
        'slot_sorten',
        'slot_ernteart',
        'slot_lage',
        'slot_anmerkungen',
        'slot_ncsent',
    ),
    'email_html'    => array
    (
        'member_firstname', // The firstname of the recipient
        'member_lastname', // The lastname of the recipient
        'member_memberno', // The member account number of the recipient
        'slot_date',
        'slot_time',
        'slot_standort',
        'slot_behaelter',
        'slot_behaelterBuchbar',
        'slot_sorten',
        'slot_ernteart',
        'slot_lage',
        'slot_anmerkungen',
        'slot_ncsent',
    )
);

$GLOBALS['NOTIFICATION_CENTER']['NOTIFICATION_TYPE']['weinanlieferung']['wa_booking_checkin'] = array
(
    'recipients'    => array
    (
        'member_email', // The email address of the recipient
        'admin_email' // The email address of the recipient
    ),
    'email_sender_address'    => array
    (
        'member_email', // The email address of the recipient
        'admin_email' // The email address of the recipient
    ),
    'email_sender_name'    => array
    (
        'member_email', // The email address of the recipient
        'admin_email' // The email address of the recipient
    ),
    'email_subject'        => array
    (
        'domain',
        'member_email',
        'admin_email',
        'slot_date',
        'slot_time',
        'slot_standort',
        'booking_ncsent',
        'booking_approved',
        'booking_approved_on',
        'booking_checked_in',
        'booking_checked_in_on',
        'booking_checked_in_ncsent',
        'booking_checkin_incomplete',
    ),
    'email_text'    => array
    (
        'member_firstname', // The firstname of the recipient
        'member_lastname', // The lastname of the recipient
        'member_memberno', // The member account number of the recipient
        'slot_date',
        'slot_time',
        'slot_standort',
        'slot_behaelter',
        'slot_sorten',
        'slot_ernteart',
        'slot_lage',
        'slot_anmerkungen',
        'booking_ncsent',
        'booking_behaelter',
        'booking_unit_name',
        'booking_unit_amount',
        'booking_sorten',
        'booking_ernteart',
        'booking_lage',
        'booking_approved',
        'booking_approved_on',
        'booking_checked_in',
        'booking_checked_in_on',
        'booking_checked_in_ncsent',
        'booking_checkin_incomplete',
        'booking_behaelter_numbers',
    ),
    'email_html'    => array
    (
        'member_firstname', // The firstname of the recipient
        'member_lastname', // The lastname of the recipient
        'member_memberno', // The member account number of the recipient
        'slot_date',
        'slot_time',
        'slot_standort',
        'slot_behaelter',
        'slot_sorten',
        'slot_ernteart',
        'slot_lage',
        'slot_anmerkungen',
        'booking_ncsent',
        'booking_behaelter',
        'booking_unit_name',
        'booking_unit_amount',
        'booking_sorten',
        'booking_ernteart',
        'booking_lage',
        'booking_approved',
        'booking_approved_on',
        'booking_checked_in',
        'booking_checked_in_on',
        'booking_checked_in_ncsent',
        'booking_checkin_incomplete',
        'booking_behaelter_numbers',
    )
);
