<?php

declare(strict_types=1);

/*
 * This file is part of contao-weinanlieferung-bundle.
 *
 * (c) vonRotenberg
 *
 * @license commercial
 */

namespace vonRotenberg\WeinanlieferungBundle\Controller\Frontend\Module;

use Contao\CoreBundle\Controller\FrontendModule\AbstractFrontendModuleController;
use Contao\CoreBundle\ServiceAnnotation\FrontendModule;
use Contao\ModuleModel;
use Contao\StringUtil;
use Contao\Template;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use vonRotenberg\WeinanlieferungBundle\Model\WeinanlieferungSlotsModel;

/**
 * @FrontendModule(WeinanlieferungSlotsListModuleController::TYPE, category="miscellaneous")
 */
class WeinanlieferungSlotsListModuleController extends AbstractFrontendModuleController
{
    public const TYPE = 'wa_slots_list';

    protected function getResponse(Template $template, ModuleModel $model, Request $request): ?Response
    {
        $standortIds = StringUtil::deserialize($model->vr_wa_standortId);

        $arrData = $template->getData();

        if (($slots = WeinanlieferungSlotsModel::findMultiplePublishedByPids($standortIds)) !== null)
        {
            foreach ($slots as $slot)
            {
                $arrData['slots'][] = $slot->row();
            }
        }

        $template->setData($arrData);

        return $template->getResponse();
    }

}
