<?php

/**
 * This file is part of contao-weinanlieferung-bundle.
 *
 * (c) vonRotenberg
 *
 * @license commercial
 */

use Contao\DC_Table;
use Contao\DataContainer;

$GLOBALS['TL_DCA']['tl_vr_wa_slottypes'] = array
(
    // Config
    'config' => array
    (
        'dataContainer'    => DC_Table::class,
        'ptable'           => 'tl_vr_wa_standort',
        'enableVersioning' => true,
        'sql'              => array
        (
            'keys' => array
            (
                'id'  => 'primary',
                'pid' => 'index'
            )
        )
    ),

    // List
    'list' => array
    (
        'sorting' => array
        (
            'mode'                    => DataContainer::MODE_PARENT,
            'fields'                  => array('title'),
            'headerFields' => array('title'),
            'flag'                    => DataContainer::SORT_ASC,
            'panelLayout'             => 'limit',
            'disableGrouping'          => true
        ),
        'label' => array(
            'fields'                  => array('title'),
            'format'                  => '%s',
        ),
        'global_operations' => array
        (
            'all' => array
            (
                'href'                => 'act=select',
                'class'               => 'header_edit_all',
                'attributes'          => 'onclick="Backend.getScrollOffset()" accesskey="e"'
            )
        ),
        'operations' => array
        (
            'edit' => array
            (
                'href'                => 'act=edit',
                'icon'                => 'edit.svg',
            ),
            'copy' => array
            (
                'href'                => 'act=paste&amp;mode=copy',
                'icon'                => 'copy.svg'
            ),
            'cut' => array
            (
                'href'                => 'act=paste&amp;mode=cut',
                'icon'                => 'cut.svg',
                'attributes'          => 'onclick="Backend.getScrollOffset()"'
            ),
            'delete' => array
            (
                'href'                => 'act=delete',
                'icon'                => 'delete.svg',
                'attributes'          => 'onclick="if(!confirm(\'' . ($GLOBALS['TL_LANG']['MSC']['deleteConfirm'] ?? null) . '\'))return false;Backend.getScrollOffset()"'
            ),
            'show' => array
            (
                'icon'                => 'show.svg',
            ),
        )
    ),

    // Palettes
    'palettes' => array
    (
        'default' => '{title_legend},title;{config_legend},duration,containers,overcapacity;{expert_legend},default'
    ),

    // Subpalettes
    'subpalettes' => array
    (
    ),

    // Fields
    'fields' => array
    (
        'id' => array
        (
            'sql'                     => "int(10) unsigned NOT NULL auto_increment"
        ),
        'pid' => array
        (
            'foreignKey'              => "tl_vr_wa_standort.title",
            'sql'                     => "int(10) unsigned NOT NULL default 0",
            'relation'                => array('type'=>'belongsTo', 'load'=>'lazy')
        ),
        'tstamp' => array
        (
            'sql'                     => "int(10) unsigned NOT NULL default 0"
        ),
        'title' => array
        (
            'exclude'                 => true,
            'sorting'                 => true,
            'flag'                    => DataContainer::SORT_INITIAL_LETTER_ASC,
            'inputType'               => 'text',
            'eval'                    => array
            (
                'mandatory' => true,
                'maxlength' => 64,
                'tl_class' => 'w50'
            ),
            'sql'                     => "varchar(64) NOT NULL default ''"
        ),
        'duration' => array
        (
            'exclude'                 => true,
            'inputType'               => 'text',
            'eval'                    => array
            (
                'mandatory' => true,
                'maxlength' => 4,
                'maxval'    => 1440,
                'minval'    => 1,
                'rgxp'      => 'natural',
                'tl_class' => 'w50'
            ),
            'sql'                     => "int(4) NOT NULL default 0"
        ),
        'containers' => array
        (
            'exclude'                 => true,
            'inputType'               => 'text',
            'eval'                    => array
            (
                'mandatory' => true,
                'maxlength' => 4,
                'maxval'    => 9999,
                'minval'    => 1,
                'rgxp'      => 'natural',
                'tl_class' => 'w50'
            ),
            'sql'                     => "int(4) NOT NULL default 0"
        ),
        'overcapacity' => array
        (
            'exclude'                 => true,
            'inputType'               => 'text',
            'eval'                    => array
            (
                'mandatory' => true,
                'rgxp'      => 'prcnt',
                'nospace'   => true,
                'tl_class' => 'w50'
            ),
            'sql'                     => "int(10) NULL"
        ),
        'default' => array
        (
            'exclude'                 => true,
            'inputType'               => 'checkbox',
            'eval'                    => array('doNotCopy'=>true, 'tl_class'=>'w50 clr'),
            'sql'                     => "char(1) NOT NULL default ''"
        ),
    )
);
