<?php

declare(strict_types=1);

/*
 * This file is part of contao-weinanlieferung-bundle.
 *
 * (c) vonRotenberg
 *
 * @license commercial
 */

namespace vonRotenberg\WeinanlieferungBundle\Model;

use Contao\Date;
use Contao\Model;

class WeinanlieferungReservationModel extends Model
{
    /**
     * Table name
     * @var string
     */
    protected static $strTable = 'tl_vr_wa_reservation';

    public static function findAllFuture(array $arrOptions=array())
    {
        $t = static::$strTable;
        $Date = new Date();
        $time = $Date->dayBegin;

        $arrColumn = ["pid IN (SELECT tl_vr_wa_slot.id FROM tl_vr_wa_slot WHERE tl_vr_wa_slot.id=tl_vr_wa_reservation.pid AND tl_vr_wa_slot.time >= ?)"];

        /*if (!isset($arrOptions['showCanceled']) || !$arrOptions['showCanceled']) {
            $arrColumn[] = "approved != '0'";
        }*/

        return static::findBy($arrColumn, $time, $arrOptions);
    }
}
