<?php

declare(strict_types=1);

/*
 * This file is part of contao-weinanlieferung-bundle.
 *
 * (c) vonRotenberg
 *
 * @license commercial
 */

namespace vonRotenberg\WeinanlieferungBundle\EventListener\DataContainer;

use Contao\CoreBundle\ServiceAnnotation\Callback;
use Contao\DataContainer;
use Contao\Date;
use Contao\Input;
use Contao\StringUtil;
use Contao\System;
use Doctrine\DBAL\Connection;
use vonRotenberg\WeinanlieferungBundle\Model\WeinanlieferungLeseartModel;
use vonRotenberg\WeinanlieferungBundle\Model\WeinanlieferungRebsorteModel;
use vonRotenberg\WeinanlieferungBundle\Model\WeinanlieferungSlotsModel;
use vonRotenberg\WeinanlieferungBundle\SlotChecker;

class WeinanlieferungSlotContainerListener
{
    /** @var Connection */
    protected $db;

    public function __construct(Connection $db)
    {
        $this->db = $db;
    }


    /**
     * @Callback(table="tl_vr_wa_slot", target="list.sorting.child_record")
     */
    public function onChildRecordCallback(array $row)
    {
        $Slot = WeinanlieferungSlotsModel::findByPk($row['id']);

        $arrSorten = [];

        $Sorten = StringUtil::deserialize($Slot->sorten,true);
        foreach($Sorten as $sorte)
        {
            $objSorte = WeinanlieferungRebsorteModel::findByPk($sorte['sorte']);
            $objLeseart = WeinanlieferungLeseartModel::findByPk($sorte['leseart']);
            $arrSorten[] = ($objSorte !== null  ? $objSorte->title : '') . ' ' . ($objLeseart !== null  ? $objLeseart->title : '');
        }

        return sprintf('<div class="tl_content_left"><div class="row u-items-center">
            <div class="col-2 text-md">%s %s</div>
            <div class="col-2">
                <div class="t-label">Buchbar ab</div>%s
                <div class="t-label">Buchbar bis</div>%s
            </div>
            <div class="col-3">
              <div class="t-label">Behälterkapazität</div>%s
            </div>
            <div class="col-3">
              <div class="t-label">Sorten</div>%s
            </div>
        </div></div>',Date::parse(Date::getNumericDateFormat(),$row['date']), Date::parse(Date::getNumericTimeFormat(),$row['time']),Date::parse(Date::getNumericDatimFormat(),$row['buchbar_ab']),Date::parse(Date::getNumericDatimFormat(),$row['buchbar_bis']),$Slot->behaelter,implode(', ',$arrSorten));
    }

    /**
     * @Callback(table="tl_vr_wa_slot", target="fields.time.save", priority=1)
     */
    public function checkAndAdjustTime($varValue, DataContainer $dc)
    {
        /** @var SlotChecker $slotchecker */
        $slotchecker = System::getContainer()->get('vonrotenberg.wa.slot_checker');

        // Return if there is no active record (override all) or no start date has been set yet
        if (!$dc->activeRecord || empty($dc->activeRecord->date))
        {
            throw new \Exception($this->translator->trans('ERR.wa_slot_nodate', [], 'contao_tl_vr_wa_slot'));
        }

        $start = strtotime(date('Y-m-d', $dc->activeRecord->date) . ' ' . date('H:i:s', $varValue));
        $duration = \intval(Input::post('duration')) !== null ? intval(Input::post('duration'))*60 : $dc->activeRecord->duration*60;

        // Todo: Introduce duration in a later update
        /*if ($slotchecker->checkTimeApplicableForSite($dc->activeRecord->pid,$start,$start+$duration,0,\intval($dc->id)))
        {
            throw new \Exception($this->translator->trans('ERR.wa_slot_conflict', [], 'contao_tl_vr_wa_slot'));
        }*/

        return $start;
    }
}
