<?php

declare(strict_types=1);

/*
 * This file is part of contao-weinanlieferung-bundle.
 *
 * (c) vonRotenberg
 *
 * @license commercial
 */

namespace vonRotenberg\WeinanlieferungBundle\EventListener\DataContainer;

use Contao\CoreBundle\ServiceAnnotation\Callback;
use Contao\DataContainer;
use Contao\Image;
use Contao\StringUtil;
use Doctrine\DBAL\Connection;
use Symfony\Contracts\Translation\TranslatorInterface;

class WeinanlieferungSlottypesContainerListener
{
    /** @var Connection */
    protected $db;

    private TranslatorInterface $translator;

    public function __construct(Connection $db, TranslatorInterface $translator)
    {
        $this->db = $db;
        $this->translator = $translator;
    }

    /**
     * @Callback(table="tl_vr_wa_slottypes", target="list.sorting.child_record")
     */
    public function onChildRecordCallback(array $row): string
    {
        $strRow = '<div class="tl_content_left">%s</div>';
        $label = $row['title'];
        $label .= ' <span style="color:#999;padding-left:3px">['.$this->translator->trans('MSC.wa_container', [], 'contao_tl_vr_wa_units').': '.$row['containers'].']</span>';
        $label .= ' <span style="color:#999;padding-left:3px">['.$this->translator->trans('MSC.wa_duration', [], 'contao_tl_vr_wa_units').': '.$row['duration'].' '.($row['duration'] == 1 ? $this->translator->trans('MSC.wa_duration_minute', [], 'contao_tl_vr_wa_units') : $this->translator->trans('MSC.wa_duration_minutes', [], 'contao_tl_vr_wa_units')).']</span>';

        if ($row['default'])
        {
            $label = Image::getHtml('bundles/vonrotenbergweinanlieferung/images/icons/check.svg', '', 'title="' . StringUtil::specialchars($this->translator->trans('tl_vr_wa_slottypes.default.0', [], 'contao_tl_vr_wa_slottypes')) . '"') . ' ' . $label;
        }

        return sprintf($strRow,$label);
    }

    /**
     * @Callback(table="tl_vr_wa_slottypes", target="fields.units.options")
     */
    public function onUnitsOptionsCallback(?DataContainer $dc): array
    {
        $arrOptions = [];

        $Units = $this->db->prepare("SELECT id, title, description, containers FROM tl_vr_wa_units ORDER BY title")
                          ->executeQuery();

        if ($Units->rowCount() > 0)
        {
            foreach ($Units->fetchAllAssociative() as $option)
            {
                $arrOptions[$option['id']] = $option['description'] ?: $option['title'].' ['.$option['containers'].' '.$this->translator->trans('MSC.wa_container', [], 'contao_tl_vr_wa_units').']';
            }
        }

        return $arrOptions;
    }

    /**
     * @Callback(table="tl_vr_wa_slottypes", target="fields.default.save")
     */
    public function checkDefault($varValue, DataContainer $dc)
    {
        if (!$varValue)
        {
            return '';
        }

        $t = $dc->table;
        $objPage = $this->db->prepare("SELECT id FROM $t WHERE `default` = 1 AND pid = ? AND id != ?")
            ->executeQuery([$dc->activeRecord->pid, $dc->activeRecord->id]);

        if ($objPage->rowCount())
        {
            throw new \Exception($this->translator->trans('ERR.wa_multiple_default', [], 'contao_tl_vr_wa_slottypes'));
        }

        return $varValue;
    }
}
