# Member Number for Behaelter Feature

This document describes the changes made to implement the feature that allows specifying a member number for each booked behaelter during check-in.

## Overview

The feature allows users to:
- Specify a different member number for each behaelter during check-in
- If no member number is provided, the system uses the logged-in member's number as a fallback
- The behaelter number and member number are stored together in the existing `behaelter_numbers` database column as a serialized array

## Changes Made

### 1. SlotAjaxController.php

- Added import for `MemberModel` class
- Updated `renderCheckin` method to:
  - Load the member model for the booking's user
  - Load the current logged-in member's model
  - Pass both to the template as `member` and `current_member`
- Updated `updateCheckin` method to:
  - Process member numbers from the form input
  - Implement fallback to use the logged-in member's number if none is provided
  - Store a combined data structure with both behaelter numbers and member numbers

### 2. modal_checkin.html.twig

- Added input fields for member numbers alongside each behaelter number select
- Set the current member's number as the default value
- Added helpful text indicating that leaving the field empty will use the current member's number
- Updated the layout to accommodate the new fields

### 3. CheckInCompletedListener.php

- Added backward compatibility to handle both the new format (array of objects with behaelter and member) and the old format (simple array of behaelter numbers)
- Updated the CSV export generation to use the member number associated with each behaelter
- Added logic to look up member information based on the member number

## Data Structure

The `behaelter_numbers` column now stores a JSON-encoded array of objects, each with:
- `behaelter`: The behaelter number
- `member`: The associated member number

Example:
```json
[
  {
    "behaelter": "123",
    "member": "456"
  },
  {
    "behaelter": "789",
    "member": "456"
  }
]
```

## Backward Compatibility

The implementation maintains backward compatibility with existing data:
- If the `behaelter_numbers` column contains the old format (simple array of behaelter numbers), it's automatically converted to the new format
- For old data, all behaelters are associated with the booking member's number

## Testing

To test this feature:
1. Log in as a member
2. Navigate to a booking that can be checked in
3. Click the check-in button
4. Enter behaelter numbers and optionally member numbers
5. Submit the form
6. Verify that the CSV export contains the correct member numbers for each behaelter
