<?php

/**
 * This file is part of contao-weinanlieferung-bundle.
 *
 * (c) vonRotenberg
 *
 * @license commercial
 */

use Contao\DC_Table;
use Contao\DataContainer;

$GLOBALS['TL_DCA']['tl_vr_wa_reservation'] = array
(

    // Config
    'config' => array
    (
        'sql'              => array
        (
            'keys' => array
            (
                'id' => 'primary',
                'pid' => 'index'
            )
        )
    ),

    'fields' => array
    (
        'id'          => array
        (
            'sql' => "int(10) unsigned NOT NULL auto_increment"
        ),
        'pid'         => array
        (
            'foreignKey' => 'tl_vr_wa_slot.time',
            'sql'        => "int(10) unsigned NOT NULL default '0'",
            'relation'   => array('type' => 'belongsTo', 'load' => 'lazy')
        ),
        'tstamp'      => array
        (
            'sql' => "int(10) unsigned NOT NULL default '0'"
        ),
        'uid'         => array
        (
            'foreignKey' => 'tl_member.username',
            'sql'        => "int(10) unsigned NOT NULL default '0'",
            'relation'   => array('type' => 'belongsTo', 'load' => 'lazy')
        ),
        'behaelter'         => array
        (
            'sql'        => "smallint(3) unsigned NOT NULL default 0",
        ),
        'sorten'       => array
        (
            'foreignKey'   => 'tl_vr_wa_rebsorte.title',
            'eval'  => array('multiple'=>true, 'csv'=>','),
            'sql'       => "blob NULL",
            'relation'   => array('type' => 'hasMany', 'load' => 'lazy')
        ),
    )
);
