<?php

declare(strict_types=1);

/*
 * This file is part of contao-weinanlieferung-bundle.
 *
 * (c) vonRotenberg
 *
 * @license commercial
 */

namespace vonRotenberg\WeinanlieferungBundle\EventListener\Backend;



use Contao\CoreBundle\Event\MenuEvent;
use Knp\Menu\Util\MenuManipulator;
use Symfony\Component\HttpFoundation\RequestStack;
use Symfony\Component\Routing\RouterInterface;
use Terminal42\ServiceAnnotationBundle\Annotation\ServiceTag;
use vonRotenberg\WeinanlieferungBundle\Controller\Backend\WeinanlieferungBookingsController;
use vonRotenberg\WeinanlieferungBundle\Controller\Backend\WeinanlieferungSlotAssistantController;

/**
 * @ServiceTag("kernel.event_listener", event="contao.backend_menu_build", priority=-255)
 */
 class BackendMenuListener
{
     protected $router;
     protected $requestStack;

     public function __construct(RouterInterface $router, RequestStack $requestStack)
     {
         $this->router = $router;
         $this->requestStack = $requestStack;
     }

     public function __invoke(MenuEvent $event): void
     {
         $factory = $event->getFactory();
         $tree = $event->getTree();
         $ref = $this->requestStack->getCurrentRequest()->attributes->get('_contao_referer_id');

         if ('mainMenu' !== $tree->getName()) {
             return;
         }

         if (($contentNode = $tree->getChild('weinanlieferung')) === null)
         {
             $contentNode = $tree->addChild('weinanlieferung');
         }

         $node = $factory
             ->createItem('booking-list')
             ->setUri($this->router->generate(WeinanlieferungBookingsController::class,['ref'=>$ref]))
             ->setLabel('Buchungsübersicht')
             ->setLinkAttribute('title', 'Übersicht aller gebuchter Anlieferungszeiten')
             ->setLinkAttribute('class', 'navigation wa-booking-list')
             ->setCurrent($this->requestStack->getCurrentRequest()->get('_controller') === WeinanlieferungBookingsController::class)
         ;

         $contentNode->addChild($node);

         $node = $factory
             ->createItem('slot-assistant')
             ->setUri($this->router->generate(WeinanlieferungSlotAssistantController::class,['ref'=>$ref]))
             ->setLabel('Slot-Assistent')
             ->setLinkAttribute('title', 'Assistent zur Massenalage von Zeitslots für Standorte')
             ->setLinkAttribute('class', 'navigation wa-slot-assistant')
             ->setCurrent($this->requestStack->getCurrentRequest()->get('_controller') === WeinanlieferungSlotAssistantController::class)
         ;

         $contentNode->addChild($node);

         $manipulator = new MenuManipulator();
         $manipulator->moveToPosition($contentNode['slot-assistant'],1);
     }
}
