<?php

declare(strict_types=1);

/*
 * This file is part of contao-weinanlieferung-bundle.
 *
 * (c) vonRotenberg
 *
 * @license commercial
 */

namespace vonRotenberg\WeinanlieferungBundle\EventListener\DataContainer;

use Contao\CoreBundle\ServiceAnnotation\Callback;
use Contao\DataContainer;
use Doctrine\DBAL\Connection;
use Symfony\Contracts\Translation\TranslatorInterface;

class WeinanlieferungSlottypesContainerListener
{
    /** @var Connection */
    protected $db;

    private TranslatorInterface $translator;

    public function __construct(Connection $db, TranslatorInterface $translator)
    {
        $this->db = $db;
        $this->translator = $translator;
    }

    /**
     * @Callback(table="tl_vr_wa_slottypes", target="list.sorting.child_record")
     */
    public function onChildRecordCallback(array $row): string
    {
        $strRow = '<div class="tl_content_left">%s</div>';
        $label = $row['title'];
        $label .= ' <span style="color:#999;padding-left:3px">['.$this->translator->trans('MSC.wa_container', [], 'contao_tl_vr_wa_units').': '.$row['containers'].']</span>';
        $label .= ' <span style="color:#999;padding-left:3px">['.$this->translator->trans('MSC.wa_duration', [], 'contao_tl_vr_wa_units').': '.$row['duration'].' '.($row['duration'] == 1 ? $this->translator->trans('MSC.wa_duration_minute', [], 'contao_tl_vr_wa_units') : $this->translator->trans('MSC.wa_duration_minutes', [], 'contao_tl_vr_wa_units')).']</span>';

        return sprintf($strRow,$label);
    }

    /**
     * @Callback(table="tl_vr_wa_slottypes", target="fields.units.options")
     */
    public function onUnitsOptionsCallback(?DataContainer $dc): array
    {
        $arrOptions = [];

        $Units = $this->db->prepare("SELECT id, title, description, containers FROM tl_vr_wa_units ORDER BY title")
                          ->executeQuery();

        if ($Units->rowCount() > 0)
        {
            foreach ($Units->fetchAllAssociative() as $option)
            {
                $arrOptions[$option['id']] = $option['description'] ?: $option['title'].' ['.$option['containers'].' '.$this->translator->trans('MSC.wa_container', [], 'contao_tl_vr_wa_units').']';
            }
        }

        return $arrOptions;
    }
}
