# Check-In CSV Export

This document describes the implementation of the CSV export functionality for checked-in bookings in the Weinanlieferung Bundle.

## Overview

When a reservation is checked in, a CSV export file is automatically generated. The file contains one line for each container (Behälter) in the booking, with detailed information about the member, grape variety, location, harvest type, and more.

## Implementation Details

The CSV export functionality is implemented in the `CheckInCompletedListener` class, which listens to the `CheckInCompletedEvent` that is dispatched when a reservation check-in is completed.

### Files Modified

1. **Modified: `src/EventListener/CheckInCompletedListener.php`**
   - Updated to generate a CSV export file for each checked-in booking
   - Added functionality to create the export directory if it doesn't exist
   - Implemented the CSV generation logic according to the requirements

2. **Modified: `config/services.yml`**
   - Added a specific service definition for the CheckInCompletedListener
   - Configured it to inject the project directory parameter

### CSV File Format

The CSV file contains one line for each container (Behälter) in the booking, with the following columns:

1. Member ID
2. Member first and last name (concatenated with space)
3. Rebsorte (grape variety) identifier
4. Rebsorte (grape variety) title
5. Lage (location) identifier
6. Lage (location) title
7. Leseart (harvest type) identifier
8. Leseart (harvest type) title
9. Ernteart (harvest method) - "H" for "handlese" or "V" for "vollernter"
10. Behälter number
11. Check-in date (format d.m.Y)
12. Behälter amount for the whole checked-in booking

### File Location and Naming

The CSV files are saved in the `/export/check_in` directory inside the project directory. If these directories don't exist, they are created automatically.

The filename is constructed using the booking ID and the member ID, separated by an underscore, with a `.csv` extension. For example: `123_456.csv`.

## How It Works

1. When a reservation is checked in, the `CheckInCompletedEvent` is dispatched in the `SlotAjaxController`.
2. The `CheckInCompletedListener` receives the event and extracts the reservation data.
3. The listener creates the export directory if it doesn't exist.
4. It retrieves the member data, container numbers, and other required information.
5. For each container, it creates a line in the CSV file with the required data.
6. It saves the CSV file in the export directory with the appropriate filename.
7. The listener logs the successful creation of the CSV file.

## Error Handling

The listener includes error handling for the following cases:

1. If the member data cannot be found, an error is logged and the CSV generation is aborted.
2. If no container numbers are found, an error is logged and the CSV generation is aborted.
3. If a container number is "9999" (special value for "Nummer nicht bekannt"), it is skipped.

## Testing

To test the CSV export functionality:

1. Check in a reservation through the frontend interface.
2. Verify that a CSV file is created in the `/export/check_in` directory.
3. Check the content of the CSV file to ensure it contains the correct data.
4. Check the Contao system log for any errors or success messages related to the CSV export.
