<?php

declare(strict_types=1);

/*
 * This file is part of contao-weinanlieferung-bundle.
 *
 * (c) vonRotenberg
 *
 * @license commercial
 */

namespace vonRotenberg\WeinanlieferungBundle\Controller\Backend;

use Contao\CoreBundle\Controller\AbstractController;
use Contao\CoreBundle\Csrf\ContaoCsrfTokenManager;
use Contao\Date;
use Contao\Environment;
use Contao\FrontendUser;
use Contao\Input;
use Contao\StringUtil;
use Contao\System;
use Doctrine\DBAL\Connection;
use Symfony\Component\HttpFoundation\RequestStack;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;
use Twig\Environment as TwigEnvironment;
use vonRotenberg\WeinanlieferungBundle\Model\WeinanlieferungLeseartModel;
use vonRotenberg\WeinanlieferungBundle\Model\WeinanlieferungRebsorteModel;
use vonRotenberg\WeinanlieferungBundle\Model\WeinanlieferungReservationModel;
use vonRotenberg\WeinanlieferungBundle\Model\WeinanlieferungSlotsModel;

/**
 * @Route("contao/weinanlieferung/buchungsliste", name=WeinanlieferungBookingsController::class, defaults={"_scope" = "backend"})
 */
class WeinanlieferungBookingsController extends AbstractController
{
    private $twig;
    private $tokenManager;
    private $request;
    private $db;

    public function __construct(TwigEnvironment $twig, ContaoCsrfTokenManager $tokenManager, RequestStack $requestStack, Connection $db)
    {
        $this->twig = $twig;
        $this->tokenManager = $tokenManager;
        $this->request = $requestStack->getCurrentRequest();
        $this->db = $db;

        $container = System::getContainer();
        $objSession = $container->get('session');


        $strKey = Input::get('popup') ? 'popupReferer' : 'referer';
        $strRefererId = $this->request->attributes->get('_contao_referer_id');

        $session = $objSession->get($strKey);
        $session[$strRefererId]['current'] = substr(Environment::get('requestUri'), \strlen(Environment::get('path')) + 1);
        $objSession->set($strKey, $session);
    }
    public function __invoke(): Response
    {
        $GLOBALS['TL_CSS']['cirrus'] = 'bundles/vonrotenbergweinanlieferung/css/backend.css|static';
        $arrData = [
            'request_token' => $this->tokenManager->getDefaultTokenValue(),
            'ref' => $this->request->attributes->get('_contao_referer_id')
        ];
        System::loadLanguageFile('default');

        // Filter
        $arrMonthOptions = [];
        $MonthRequest = $this->db->executeQuery("SELECT s.date, DATE_FORMAT(FROM_UNIXTIME(s.date),'%m/%Y') as 'month_label' FROM tl_vr_wa_reservation r INNER JOIN tl_vr_wa_slot s ON s.id = r.pid GROUP BY month_label, s.date ORDER BY s.date ASC");

        foreach ($MonthRequest->iterateAssociative() as $month)
        {
            $arrMonthOptions[$month['date']] = $month['month_label'];
        }


        // Get bookings
        if (($bookings = WeinanlieferungReservationModel::findAllFuture(['order' => "(SELECT tl_vr_wa_slot.time FROM tl_vr_wa_slot WHERE tl_vr_wa_slot.id=tl_vr_wa_reservation.pid) ASC"])) !== null)
        {
            /** @var WeinanlieferungReservationModel $booking */
            foreach ($bookings as $booking)
            {
                /** @var WeinanlieferungSlotsModel $Slot */
                if (($Slot = $booking->getRelated('pid')) !== null)
                {
                    $day = new Date($Slot->date);
                    $arrSorten = [];
                    $arrErnteart = [];
                    $arrLagen = [];

                    if (!isset($arrData['days'][$day->dayBegin][$Slot->pid]))
                    {
                        $Standort = $Slot->getRelated('pid');

                        $arrData['days'][$day->dayBegin][$Slot->pid] = [
                            'standort' => $Standort !== null ? $Standort->title : ''
                        ];

                    }

                    if (!isset($arrData['days'][$day->dayBegin][$Slot->pid]['times'][$Slot->time]))
                    {
                        $arrSortenAvailable = [];
                        $Sorten = StringUtil::deserialize($Slot->sorten,true);
                        foreach($Sorten as $sorte)
                        {
                            $objSorte = WeinanlieferungRebsorteModel::findByPk($sorte['sorte']);
                            $objLeseart = WeinanlieferungLeseartModel::findByPk($sorte['leseart']);
                            $arrSortenAvailable[] = ($objSorte !== null  ? $objSorte->title : '') . ' ' . ($objLeseart !== null  ? $objLeseart->title : '');
                        }
                        $arrData['days'][$day->dayBegin][$Slot->pid]['times'][$Slot->time] = array_merge($Slot->row(),[
                            'sorten' => $arrSortenAvailable,
                            'behaelterAvailable' => $Slot->getAvailableBehaelter(),
                        ]);
                    }

                    if ($booking->sorten !== null)
                    {
                        $SortenLeseart = explode(';', $booking->sorten);
                        foreach ($SortenLeseart as $sorteLeseart)
                        {
                            list($sorte, $leseart) = explode(',', $sorteLeseart);
                            $objSorte = WeinanlieferungRebsorteModel::findByPk($sorte);
                            $objLeseart = WeinanlieferungLeseartModel::findByPk($leseart);
                            $arrSorten[$objSorte->id . ',' . $objLeseart->id] = ($objSorte !== null ? $objSorte->title : '') . ' ' . ($objLeseart !== null ? $objLeseart->title : '');
                        }
                    }

                    if ($booking->ernteart !== null)
                    {
                        foreach (explode(',', $booking->ernteart) as $ernteart)
                        {
                            $arrErnteart[$ernteart] = $GLOBALS['TL_LANG']['REF']['wa_ernteart'][$ernteart] ?? $ernteart;
                        }
                    }

                    if (($Lagen = $booking->getRelated('lage')) !== null)
                    {
                        foreach ($Lagen as $lage)
                        {
                            $arrLagen[$lage->id] = $lage->title;
                        }
                    }

                    $strStandort = '';
                    if (($Standort = $Slot->getRelated('pid')) !== null)
                    {
                        $strStandort = $Standort->title;
                    }

                    $arrData['days'][$day->dayBegin][$Slot->pid]['times'][$Slot->time]['items'][] = array_merge($booking->row(), [
                        'sorte'              => $arrSorten,
                        'ernteart' => $arrErnteart,
                        'lage' => $arrLagen,
                        'slot'  => $Slot->row(),
                        'standort' => $strStandort,
                        'member' => $booking->getRelated('uid') !== null ? $booking->getRelated('uid')->row() : null
                    ]);
                }
            }
        }

        return new Response(
            $this->twig->render(
                '@Contao_VonrotenbergWeinanlieferungBundle/be_wa_buchungsliste.html.twig',
                $arrData
            )
        );
    }
}
