<?php

declare(strict_types=1);

/*
 * This file is part of contao-weinanlieferung-bundle.
 *
 * (c) vonRotenberg
 *
 * @license commercial
 */

namespace vonRotenberg\WeinanlieferungBundle\Model;

use Contao\Database;
use Contao\Model;
use Contao\Model\Registry;

class WeinanlieferungSlotsModel extends Model
{
    /**
     * Table name
     * @var string
     */
    protected static $strTable = 'tl_vr_wa_slot';

    public static function findPublishedByPid($intPid, array $arrOptions=array())
    {
        $time = time();
        $t = static::$strTable;
        $arrColumns = array("$t.pid=?");

        // Skip unsaved elements (see #2708)
        $arrColumns[] = "$t.tstamp!=0";

        $arrColumns[] = "$t.buchbar='1' AND $t.buchbar_bis>$time";

        if (!isset($arrOptions['order']))
        {
            $arrOptions['order'] = "$t.time ASC";
        }

        return static::findBy($arrColumns, $intPid, $arrOptions);
    }

    public static function findMultiplePublishedByPids(array $arrPids, array $arrOptions=array())
    {
        if (empty($arrPids) || !\is_array($arrPids))
        {
            return null;
        }

        $arrPids = array_filter($arrPids, function($var) {
            return is_numeric($var);
        });

        if (empty($arrPids))
        {
            return null;
        }

        $time = time();
        $t = static::$strTable;
        $arrColumns = array("$t.pid IN (".implode(',',$arrPids).")");

        // Skip unsaved elements (see #2708)
        $arrColumns[] = "$t.tstamp!=0";

        $arrColumns[] = "$t.buchbar='1' AND $t.buchbar_bis>$time";

        if (!isset($arrOptions['order']))
        {
            $arrOptions['order'] = "$t.time ASC";
        }

        return static::findBy($arrColumns,null,$arrOptions);
    }
}
