<?php

/**
 * This file is part of contao-weinanlieferung-bundle.
 *
 * (c) vonRotenberg
 *
 * @license commercial
 */

use Contao\CoreBundle\DataContainer\PaletteManipulator;

// Extend the default palette
PaletteManipulator::create()
    ->addLegend('standort_legend', 'redirect_legend', PaletteManipulator::POSITION_BEFORE)
    ->addField('standorts', 'standort_legend', PaletteManipulator::POSITION_APPEND)
    ->applyToPalette('default', 'tl_member_group')
;

// Add fields to tl_member_group
$GLOBALS['TL_DCA']['tl_member_group']['fields']['standorts'] = array
(
    'exclude'                 => true,
    'inputType'               => 'checkbox',
    'foreignKey'              => 'tl_vr_wa_standort.title',
    'eval'                    => array('multiple'=>true),
    'sql'                     => "blob NULL"
);
