<?php

declare(strict_types=1);

/*
 * This file is part of contao-weinanlieferung-bundle.
 *
 * (c) vonRotenberg
 *
 * @license commercial
 */

namespace vonRotenberg\WeinanlieferungBundle\EventListener\DataContainer;

use Contao\CoreBundle\ServiceAnnotation\Callback;
use Contao\DataContainer;
use Contao\Date;
use Contao\StringUtil;
use Doctrine\DBAL\Connection;
use vonRotenberg\WeinanlieferungBundle\Model\WeinanlieferungLeseartModel;
use vonRotenberg\WeinanlieferungBundle\Model\WeinanlieferungRebsorteModel;
use vonRotenberg\WeinanlieferungBundle\Model\WeinanlieferungSlotsModel;

class WeinanlieferungReservationContainerListener
{
    /** @var Connection */
    protected $db;

    public function __construct(Connection $db)
    {
        $this->db = $db;
    }


    /**
     * @Callback(table="tl_vr_wa_reservation", target="fields.sorten.options")
     */
    public function onSortenOptionsCallback(DataContainer $dc)
    {
        $arrSorten = [];

        if (($Slot = WeinanlieferungSlotsModel::findByPk($dc->activeRecord->pid)) === null)
        {
            return $arrSorten;
        }

        $Sorten = StringUtil::deserialize($Slot->sorten,true);
        foreach($Sorten as $sorte)
        {
            $objSorte = WeinanlieferungRebsorteModel::findByPk($sorte['sorte']);
            $objLeseart = WeinanlieferungLeseartModel::findByPk($sorte['leseart']);
            $arrSorten[$objSorte->id.','.$objLeseart->id] = ($objSorte !== null  ? $objSorte->title : '') . ' ' . ($objLeseart !== null  ? $objLeseart->title : '');
        }

        return $arrSorten;
    }

    /**
     * @Callback(table="tl_vr_wa_reservation", target="fields.lage.options")
     */
    public function onLageOptionsCallback(DataContainer $dc)
    {
        $arrLagen = [];

        if (($Slot = WeinanlieferungSlotsModel::findByPk($dc->activeRecord->pid)) === null || $Slot->lage === null)
        {
            return $arrLagen;
        }

        if (($Lagen = $Slot->getRelated('lage')) !== null)
        {
            $arrLagen = array_combine($Lagen->fetchEach('id'),$Lagen->fetchEach('title'));
        }

        return $arrLagen;
    }

    /**
     * @Callback(table="tl_vr_wa_reservation", target="fields.ernteart.options")
     */
    public function onErnteartOptionsCallback(DataContainer $dc)
    {
        $arrErnteart = [];

        if (($Slot = WeinanlieferungSlotsModel::findByPk($dc->activeRecord->pid)) === null || $Slot->ernteart === null)
        {
            return $arrErnteart;
        }

        $Ernteart = explode(',',$Slot->ernteart);
        foreach($Ernteart as $art)
        {
            $arrErnteart[$art] = $GLOBALS['TL_LANG']['REF']['wa_ernteart'][$art] ?? $art;
        }

        return $arrErnteart;
    }

    /**
     * @Callback(table="tl_vr_wa_reservation", target="fields.pid.options")
     */
    public function onPidOptionsCallback(DataContainer $dc)
    {
        if (($Slots = WeinanlieferungSlotsModel::findAllFuturePublished()) === null)
        {
            return [];
        }

        $arrData = [];
        foreach ($Slots as $slot)
        {
            $arrSorten = [];
            $intAvailableBehaelter = $slot->getAvailableBehaelter();

            $Sorten = StringUtil::deserialize($slot->sorten,true);
            foreach($Sorten as $sorte)
            {
                $objSorte = WeinanlieferungRebsorteModel::findByPk($sorte['sorte']);
                $objLeseart = WeinanlieferungLeseartModel::findByPk($sorte['leseart']);
                $arrSorten[] = ($objSorte !== null  ? $objSorte->title : '') . ' ' . ($objLeseart !== null  ? $objLeseart->title : '');
            }
            $arrData[$slot->id] = Date::parse(Date::getNumericDatimFormat(),$slot->time) . ' - (' . implode(', ',$arrSorten) . ') [Verfügbare Behälter: ' . $intAvailableBehaelter . '/' . $slot->behaelter . ']';
        }

        return $arrData;
    }

    /**
     * @Callback(table="tl_vr_wa_reservation", target="fields.uid.options")
     */
    public function onUidOptionsCallback(DataContainer $dc)
    {
        if (($Members = \MemberModel::findAll()) === null)
        {
            return [];
        }

        $arrData = [];
        foreach ($Members as $member)
        {
            $arrData[$member->id] = ($member->memberno !== null && $member->memberno ? $member->memberno.' ' : '') . $member->firstname . ' ' . $member->lastname . ' [' . $member->email . ']';
        }

        return $arrData;
    }
}
