<?php

declare(strict_types=1);

/*
 * This file is part of contao-weinanlieferung-bundle.
 *
 * (c) vonRotenberg
 *
 * @license commercial
 */

namespace vonRotenberg\WeinanlieferungBundle\EventListener\DataContainer;

use Contao\CoreBundle\ServiceAnnotation\Callback;
use Contao\DataContainer;
use Doctrine\DBAL\Connection;

class WeinanlieferungStandortContainerListener
{
    /** @var Connection */
    protected $db;

    public function __construct(Connection $db)
    {
        $this->db = $db;
    }

    /**
     * @Callback(table="tl_vr_wa_standort", target="fields.nc_notification.options")
     */
    public function onNcNotificationOptionsCallback(DataContainer $dc)
    {
        $arrOptions = [];
        $objNotifications = $this->db->executeQuery("SELECT id,title FROM tl_nc_notification WHERE type='wa_booking_change' ORDER BY title");

        if (!$objNotifications->rowCount())
        {
            return $arrOptions;
        }

        foreach ($objNotifications->fetchAllAssociative() as $notification)
        {
            $arrOptions[$notification['id']] = $notification['title'];
        }

        return $arrOptions;
    }
}
