<?php

/**
 * This file is part of contao-weinanlieferung-bundle.
 *
 * (c) vonRotenberg
 *
 * @license commercial
 */

use Contao\DC_Table;
use Contao\DataContainer;

$GLOBALS['TL_DCA']['tl_vr_wa_units'] = array
(
    // Config
    'config' => array
    (
        'dataContainer'    => DC_Table::class,
        'enableVersioning' => true,
        'sql'              => array
        (
            'keys' => array
            (
                'id'  => 'primary'
            )
        )
    ),

    // List
    'list' => array
    (
        'sorting' => array
        (
            'mode'                    => DataContainer::MODE_SORTED,
            'fields'                  => array('title'),
            'flag'                    => DataContainer::SORT_INITIAL_LETTER_ASC,
            'panelLayout'             => 'limit'
        ),
        'label' => array(
            'fields'                  => array('title','description'),
            'format'                  => '%s',
            'showColumns'             => true
        ),
        'global_operations' => array
        (
            'all' => array
            (
                'href'                => 'act=select',
                'class'               => 'header_edit_all',
                'attributes'          => 'onclick="Backend.getScrollOffset()" accesskey="e"'
            )
        ),
        'operations' => array
        (
            'edit' => array
            (
                'href'                => 'act=edit',
                'icon'                => 'edit.gif',
            ),
            'copy' => array
            (
                'href'                => 'act=copy',
                'icon'                => 'copy.svg'
            ),
            'cut' => array
            (
                'href'                => 'act=paste&amp;mode=cut',
                'icon'                => 'cut.svg',
                'attributes'          => 'onclick="Backend.getScrollOffset()"'
            ),
            'delete' => array
            (
                'href'                => 'act=delete',
                'icon'                => 'delete.gif',
            ),
            'show' => array
            (
                'icon'                => 'show.gif',
            ),
        )
    ),

    // Palettes
    'palettes' => array
    (
        'default' => '{title_legend},title,description;{unit_legend},containers'
    ),

    // Subpalettes
    'subpalettes' => array
    (
    ),

    // Fields
    'fields' => array
    (
        'id' => array
        (
            'sql'                     => "int(10) unsigned NOT NULL auto_increment"
        ),
        'tstamp' => array
        (
            'sql'                     => "int(10) unsigned NOT NULL default 0"
        ),
        'title' => array
        (
            'exclude'                 => true,
            'sorting'                 => true,
            'flag'                    => DataContainer::SORT_INITIAL_LETTER_ASC,
            'inputType'               => 'text',
            'eval'                    => array
            (
                'mandatory' => true,
                'maxlength' => 64,
                'tl_class' => 'w50'
            ),
            'sql'                     => "varchar(64) NOT NULL default ''"
        ),
        'description' => array
        (
            'exclude'                 => true,
            'inputType'               => 'text',
            'eval'                    => array
            (
                'mandatory' => false,
                'maxlength' => 64,
                'tl_class' => 'w50'
            ),
            'sql'                     => "varchar(64) NOT NULL default ''"
        ),
        'containers' => array
        (
            'exclude'                 => true,
            'inputType'               => 'text',
            'eval'                    => array
            (
                'mandatory' => true,
                'maxlength' => 4,
                'maxval'    => 9999,
                'minval'    => 1,
                'rgxp'      => 'natural',
                'tl_class' => 'w50'
            ),
            'sql'                     => "int(4) NOT NULL default 0"
        )
    )
);
