<?php

declare(strict_types=1);

/*
 * This file is part of contao-weinanlieferung-bundle.
 *
 * (c) vonRotenberg
 *
 * @license commercial
 */

namespace vonRotenberg\WeinanlieferungBundle\EventListener\DataContainer;

use Contao\CoreBundle\ServiceAnnotation\Callback;
use Contao\DataContainer;
use Contao\StringUtil;
use Doctrine\DBAL\Connection;

class WeinanlieferungStandortContainerListener
{
    /** @var Connection */
    protected $db;

    public function __construct(Connection $db)
    {
        $this->db = $db;
    }

    /**
     * @Callback(table="tl_vr_wa_standort", target="fields.nc_notification.options")
     */
    public function onNcNotificationOptionsCallback(DataContainer $dc)
    {
        $arrOptions = [];
        $objNotifications = $this->db->executeQuery("SELECT id,title FROM tl_nc_notification WHERE type='wa_booking_change' ORDER BY title");

        if (!$objNotifications->rowCount())
        {
            return $arrOptions;
        }

        foreach ($objNotifications->fetchAllAssociative() as $notification)
        {
            $arrOptions[$notification['id']] = $notification['title'];
        }

        return $arrOptions;
    }

    /**
     * @Callback(table="tl_vr_wa_standort", target="fields.nc_notification_slots.options")
     */
    public function onNcNotificationSlotsOptionsCallback(DataContainer $dc)
    {
        $arrOptions = [];
        $objNotifications = $this->db->executeQuery("SELECT id,title FROM tl_nc_notification WHERE type='wa_slot_change' ORDER BY title");

        if (!$objNotifications->rowCount())
        {
            return $arrOptions;
        }

        foreach ($objNotifications->fetchAllAssociative() as $notification)
        {
            $arrOptions[$notification['id']] = $notification['title'];
        }

        return $arrOptions;
    }

    /**
     * @Callback(table="tl_vr_wa_standort", target="fields.nc_notification_checkin.options")
     */
    public function onNcNotificationCheckinOptionsCallback(DataContainer $dc)
    {
        $arrOptions = [];
        $objNotifications = $this->db->executeQuery("SELECT id,title FROM tl_nc_notification WHERE type='wa_booking_checkin' ORDER BY title");

        if (!$objNotifications->rowCount())
        {
            return $arrOptions;
        }

        foreach ($objNotifications->fetchAllAssociative() as $notification)
        {
            $arrOptions[$notification['id']] = $notification['title'];
        }

        return $arrOptions;
    }

    /**
     * @Callback(table="tl_vr_wa_standort", target="fields.number_ranges.save")
     */
    public function onNumberRangesSaveCallback($varValue, DataContainer $dc)
    {
        if (empty($varValue)) {
            return '';
        }

        // Remove whitespace
        $varValue = preg_replace('/\s+/', '', $varValue);

        // Check if the input contains only numbers, hyphens, and commas
        if (!preg_match('/^[0-9,-]+$/', $varValue)) {
            throw new \Exception($GLOBALS['TL_LANG']['ERR']['invalidNumberRanges']);
        }

        // Validate each part (number or range)
        $parts = StringUtil::trimsplit(',', $varValue);
        $validatedParts = [];

        foreach ($parts as $part) {
            // Check if it's a range (contains a hyphen)
            if (strpos($part, '-') !== false) {
                list($start, $end) = explode('-', $part, 2);

                // Ensure both start and end are valid numbers
                if (!is_numeric($start) || !is_numeric($end)) {
                    throw new \Exception($GLOBALS['TL_LANG']['ERR']['invalidNumberRanges']);
                }

                // Ensure the range is valid (start <= end)
                if ((int)$start > (int)$end) {
                    throw new \Exception($GLOBALS['TL_LANG']['ERR']['invalidNumberRange']);
                }

                $validatedParts[] = $start . '-' . $end;
            } else {
                // Ensure it's a valid number
                if (!is_numeric($part)) {
                    throw new \Exception($GLOBALS['TL_LANG']['ERR']['invalidNumberRanges']);
                }

                $validatedParts[] = $part;
            }
        }

        return implode(', ', $validatedParts);
    }
}
