<?php

declare(strict_types=1);

/*
 * This file is part of contao-weinanlieferung-bundle.
 *
 * (c) vonRotenberg
 *
 * @license commercial
 */

namespace vonRotenberg\WeinanlieferungBundle\Controller\Frontend\Module;

use Contao\Controller;
use Contao\CoreBundle\Controller\FrontendModule\AbstractFrontendModuleController;
use Contao\CoreBundle\Exception\ResponseException;
use Contao\CoreBundle\InsertTag\InsertTagParser;
use Contao\CoreBundle\ServiceAnnotation\FrontendModule;
use Contao\Date;
use Contao\FrontendUser;
use Contao\ModuleModel;
use Contao\StringUtil;
use Contao\Template;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use vonRotenberg\WeinanlieferungBundle\Model\WeinanlieferungRebsorteModel;
use vonRotenberg\WeinanlieferungBundle\Model\WeinanlieferungReservationModel;
use vonRotenberg\WeinanlieferungBundle\Model\WeinanlieferungSlotsModel;

/**
 * @FrontendModule(WeinanlieferungBookedListModuleController::TYPE, category="miscellaneous")
 */
class WeinanlieferungBookedListModuleController extends AbstractFrontendModuleController
{
    public const TYPE = 'wa_booked_list';

    private $insertTagParser;

    public function __construct(InsertTagParser $insertTagParser)
    {
        $this->insertTagParser = $insertTagParser;
    }


    protected function getResponse(Template $template, ModuleModel $model, Request $request): ?Response
    {
        $arrData = $template->getData();

        // Get bookings
        if (($bookings = WeinanlieferungReservationModel::findBy("uid",FrontendUser::getInstance()->id)) !== null)
        {
            /** @var WeinanlieferungReservationModel $booking */
            foreach ($bookings as $booking)
            {
                if (($Slot = $booking->getRelated('pid')) !== null)
                {
                    $day = new Date($booking->date);
                    $arrSorten = [];

                    if (($Sorten = $booking->getRelated('sorten')) !== null)
                    {
                        $arrSorten = $Sorten->fetchEach('title');
                    }

                    $arrData['days'][$day->dayBegin][] = array_merge($booking->row(), [
                        'sorte'              => $arrSorten,
                        'slot'  => $Slot->row()
                    ]);
                }
            }
        }

        $template->setData($arrData);

        // Handle ajax
        if ($request->headers->get('VR-Ajax') == 'WaBookedModule')
        {
            throw new ResponseException(new Response($this->insertTagParser->replace($template->parse())));
        }

        return $template->getResponse();
    }

}
