<?php

declare(strict_types=1);

/*
 * This file is part of contao-weinanlieferung-bundle.
 *
 * (c) vonRotenberg
 *
 * @license commercial
 */

namespace vonRotenberg\WeinanlieferungBundle\Controller\Frontend\Ajax;

use Contao\Controller;
use Contao\CoreBundle\Controller\AbstractController;
use Contao\CoreBundle\Framework\ContaoFramework;
use Contao\CoreBundle\Security\Authentication\Token\TokenChecker;
use Contao\FrontendUser;
use Contao\Input;
use Contao\System;
use Doctrine\DBAL\Connection;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;
use Symfony\Contracts\Translation\TranslatorInterface;
use vonRotenberg\WeinanlieferungBundle\Model\WeinanlieferungReservationModel;
use vonRotenberg\WeinanlieferungBundle\Model\WeinanlieferungSlotsModel;

/**
 * @Route("/_ajax/vr_wa/v1/slot", name="vr_wa_slot_ajax", defaults={"_scope" = "frontend", "_token_check" = false})
 */
class SlotAjaxController extends AbstractController
{
    private $tokenChecker;
    private $translator;
    private $framework;

    public function __construct(ContaoFramework $framework, TokenChecker $tokenChecker, TranslatorInterface $translator)
    {
        $this->framework = $framework;
        $this->tokenChecker = $tokenChecker;
        $this->translator = $translator;
    }

    public function __invoke(Request $request)
    {
        System::loadLanguageFile('default');

        if (!$this->tokenChecker->hasFrontendUser())
        {
            return $this->renderUnauthorized();
        }

        if (empty($_REQUEST['do']))
        {
            return new Response('Required parameter missing',412);
        }

        switch ($_REQUEST['do'])
        {
            case 'details':
                return $this->renderDetails();
                break;

            case 'reservate':
                return $this->reservate();

            case 'delete':
                return $this->deleteBooking();
        }

        return new Response('',500);
        return new Response(null,203);
    }

    protected function renderDetails()
    {
        if (empty($_REQUEST['id']))
        {
            return new Response('Required parameter missing',412);
        }

        if (($Slot = WeinanlieferungSlotsModel::findPublishedById($_REQUEST['id'])) === null)
        {
            return new Response('Could not load slot data',500);
        }

        $arrSorten = [];
        if (($Sorten = $Slot->getRelated('sorte')) !== null)
        {
            $arrSorten = array_combine($Sorten->fetchEach('id'),$Sorten->fetchEach('title'));
        }

        $intAvailableBehaelter = $Slot->getAvailableBehaelter();

        $arrData = [
            'id'       => $Slot->id,
            'slot'     => array_merge($Slot->row(),[
                'sorte' => $arrSorten,
                'behaelterAvailable' => $intAvailableBehaelter
            ]),
            'standort' => $Slot->getRelated('pid'),
            'buchen' => [
                'buchbar' => (boolean) $intAvailableBehaelter,
                'behaelter' => range(min($intAvailableBehaelter,1),$intAvailableBehaelter),
                'sorten' => $arrSorten
            ]
        ];

        return $this->render('@Contao/modal_slot_details.html.twig',$arrData);
    }

    protected function reservate()
    {
        if (empty($_REQUEST['id']) || empty(Input::post('behaelter')) || empty(Input::post('sorten')))
        {
            return new Response('Missing parameter',500);
        }

        $arrSorten = [];
        if (!is_array(Input::post('sorten')))
        {
            $arrSorten[] = Input::post('sorten');
        } else {
            $arrSorten = implode(',', Input::post('sorten'));
        }

        $Reservation = new WeinanlieferungReservationModel();

        $Reservation->setRow([
            'pid' => $_REQUEST['id'],
            'tstamp' => time(),
            'uid' => FrontendUser::getInstance()->id,
            'behaelter' => Input::post('behaelter'),
            'sorten' => $arrSorten
        ]);


        $Reservation->save();

        return new Response('<p>Reservierung erfolgreich</p>');
    }

    protected function deleteBooking()
    {
        if (empty($_REQUEST['id']))
        {
            return new Response('Missing parameter',500);
        }

        /** @var Connection $db */
        $db = Controller::getContainer()->get('database_connection');

        $arrCriteria = [
            'uid' => FrontendUser::getInstance()->id,
            'id' => $_REQUEST['id']
        ];

        if ($db->delete('tl_vr_wa_reservation',$arrCriteria))
        {
            return new Response(null,203);
        }

        return new Response('Could not delete',500);
    }

    protected function renderUnauthorized()
    {
        return $this->render('@Contao/modal_unauthorized.html.twig');
    }

}
